<!DOCTYPE html>
<head>
<style>
.error {color: #FF0000;}
</style>
<script>
function run() {
    var out = document.getElementById("out");
    out.value += " "; // doesn't matter how it is updated
    out.focus();
    var in = document.getElementById("in");
    in.focus();
}
</script>
</head>
<body  onload="run()">
<?php
$vals;
include "include/echo_hides.php";

if(empty($_POST)){// no response if no post
	die("Please run from intro1.php");
}

$xml=simplexml_load_file("ddd.xml");
$rows = $xml->props["rows"];
$cols = $xml->props["cols"];
echo "<h4>" . $xml->props["title"] . "</h4>\n";

$in = $_POST["in"];// in is what user typed
$out = $_POST["out"];// out is from the textarea
$out = $out . " " . $in; 
$row = (integer)$_POST['row'];
$col = (integer)$_POST['col'];
$hp = (integer)$_POST['hp'];
$strength = (integer)$_POST['strength'];
$inv = (integer)$_POST['inv'];
$npc = (integer)$_POST['npc'];
$pt = (integer)$_POST['pt'];
$stage = (integer)$_POST['stage'];
$uname = $_POST['uname'];
$headLine = "<h3>Ed's Game Server v2</h3>\n";
$ok = true;//monitors movement
$index = 0; // position of scene in xml
$prompt = "";

function fixPlayerValues(){
  global $out;
  global $hp;
  global $strength;
  global $xml;
  
  $hpmax = (integer) $xml->player['hpmax'];
  $strengthmax = (integer) $xml->player['strengthmax'];
  $hp = rand(3,$hpmax);
  $strength = rand(3, $strengthmax);
  $out = "$out\nYour strength is $strength and your health is $hp\n";

}
function getSceneIndex($row1, $col1, $xml){
  global $row;
  global $col;
  $index = -1;
  
  for($i = 0; $i <  $xml->scene->count(); $i++) {
    $r = (integer) $xml->scene[$i]['row'];
    $c = (integer) $xml->scene[$i]['col'];

	if ($row1 == $r && $col1 == $c) {
	  $index = $i;
	  //$vals = "You are at row $row, column $col.\n";

    }
  }
  return $index;
}
function getItemIndex($itemKey){
  global $xml;
  $index = -1;
  
  for($i = 0; $i <  $xml->item->count(); $i++) {
    $key = $xml->item[$i]['key'];
	//echo "<br>getItemIndex: itemKey $itemKey, key: $key, i: $i ";
	if (strcmp($itemKey, $key) == 0) {
	  $index = $i;
    }
  }
  return $index;
}
function getNPCIndex($npcKey){
  global $xml;
  $index = -1;
  
  for($i = 0; $i <  $xml->npc->count(); $i++) {
    $key = $xml->npc[$i]['key'];
	//echo "<br>getNPCIndex: npcKey $npcKey, key: $key, i: $i ";
	if (strcmp($npcKey, $key) == 0) {
	  $index = $i;
    }
  }
  return $index;
}
// adjust $row and $col
function setNewLocation($direction) {
  global $in;
  global $out;
  global $xml;
  global $rows;
  global $cols;
  global $row;
  global $col;
  global $ok;
  
  //echo $headLine;
  switch ($in) {
    case "e": if($col < ($cols -1))  $col++; else $ok = false; break;
    case "s": if($row < ($rows -1))  $row++; else $ok = false; break;
    case "w": if($col > 0)           $col--; else $ok = false; break;
    case "n": if($row > 0)           $row--; else $ok = false; break;
	case "q": die ("Thank you for playing"); break;
    default:  $out = $out ."I do not understand <$in>";
  }
  if (! $ok) {
	  $row = -1;
	  $col = -1;
  }
  $vals = "You are at row $row, column $col.\n";
  $index = getSceneIndex($row, $col, $xml);
  $out = $vals; // . $xml->scene[$index]->desc . "\n";

}
function descToout($desc) {
	global $out;
	global $uname;
	
	$desc1 = str_replace("-playerName-", $uname, $desc);
  	$out = $out.$desc1;
}
function getItemPresentation($xml, $index, $itemKey){
	$answer = "";
	$name = (string)$xml->item[$index]['name'];
	$answer = "$answer\nYou see a $itemKey: name: $name";
    $type = (string)$xml->item[$index]['type'];
    $answer = "$answer, type: $type";
    $weight = (string)$xml->item[$index]['weight'];
    $answer = "$answer, weight: $weight";
    $damagefactor = (string)$xml->item[$index]['damagefactor'];
    $answer = "$answer, damage factor: $damagefactor";
    $strengthadd = (string)$xml->item[$index]['strengthadd'];
    $answer = "$answer, strength add: $strengthadd\n";
	
	return $answer;
}
function getNPCPresentation($xml, $index, $itemKey){
	$answer = "";
	$name = (string)$xml->npc[$index]['name'];
	$answer = "$answer\nYou see a $itemKey: name: $name";
    $type = (string)$xml->npc[$index]['type'];
    $answer = "$answer, type: $type";
    $hpmax = (string)$xml->npc[$index]['hpmax'];
    $answer = "$answer, hpmax: $hpmax";
    $points = (string)$xml->npc[$index]['points'];
    $answer = "$answer, points: $points";
    $strengthmax = (string)$xml->npc[$index]['strengthmax'];
    $answer = "$answer, strength max: $strengthmax\n";
	
	return $answer;
}
function showItem($itemKey){
	global $xml;
	global $out;
	global $prompt;
	global $stage;
	global $inv;  // 0 if item still available to take
	if($itemKey) {
	  $index = getItemIndex($itemKey);
	  if($index >= 0) {
		  $mask = (integer)$xml->item[$index]['mask'];
		  $taken = $mask & $inv; // bitwise and
		  echo "<br>showItem: mask: $mask, inv: $inv, taken: $taken<br>\n";
		  if ($taken == 0) {
			  $out = $out . getItemPresentation($xml, $index, $itemKey);
		      $prompt = "Would you like to take this item(y/n)?";
		      $stage = 7;
		  }
	  } else {
		  echo "could not find $itemKey";
	  }
	}
  }function showNPC($npcKey){
	global $xml;
	global $out;
	global $prompt;
	global $stage;
	global $npc;  // 0 if item still available to take
	if($npcKey) {
	  $index = getNPCIndex($npcKey);
	  if($index >= 0) {
		  $fight = (integer)$xml->npc[$index]['fight'];
		  $mask = (integer)$xml->npc[$index]['mask'];
		  $taken = $mask & $npc; // bitwise and
		  echo "<br>showNPC: mask: $mask, npc: $npc, taken: $taken<br>\n";
		  if ($taken == 0) {
			  $out = $out . getNPCPresentation($xml, $index, $npcKey);
			  $desc = $xml->npc[$index]->alive->desc;
              descToout($desc);

		      //$prompt = "Would you like to take this NPC(y/n)?";
		      //$stage = 8;
			  $stage = 6; //todo
		  }
	  } else {
		  echo "could not find $npcKey";
	  }
	}
  }
function getItemKeyByMask($mask) {
    global $xml;
	$itemKey = "";
	$index = -1;
	$answer = "";
  
  for($i = 0; $i <  $xml->item->count(); $i++) {
    $itemKey = $xml->item[$i]['key'];
    $m = (integer) $xml->item[$i]['mask'];
	//echo "<br>getItemIndex: itemKey $itemKey, key: $key, i: $i ";
	if ($m == $mask) {
	  $answer = $itemKey;
    }
  }
  return $answer;
}
function showInventory($index){
	global $inv;
	global $out;
	$mask = 1;
	$separator = "";
	$inventory = "\nYour inventory: [";
	while ($mask < 129) { // up to and including 8 items
	    $isInIventory = $mask & $inv;
		if ($isInIventory) {
	        $itemKey = getItemKeyByMask($mask);
            if($itemKey) {
                $inventory = $inventory . "$separator$itemKey";
                $separator = ", ";
		    }
		}
		$mask = $mask * 2;
	}
    $inventory = $inventory . "]";
	$out = $out . $inventory;
}
function getNPCKeyByMask($mask) {
    global $xml;
	$npcKey = "";
	$index = -1;
	$answer = "";
  
  for($i = 0; $i <  $xml->npc->count(); $i++) {
    $itemKey = $xml->npc[$i]['key'];
    $m = (integer) $xml->npc[$i]['mask'];
	//echo "<br>getItemIndex: itemKey $itemKey, key: $key, i: $i ";
	if ($m == $mask) {
	  $answer = $npcKey;
    }
  }
  return $answer;
}
function showScene() {
  global $col;
  global $prompt;
  global $row;
  global $stage;
  global $in;
  global $index;// index pointing to current scene
  global $xml;
  
  $desc = $xml->scene[$index]->desc;
  descToout($desc);
  $npcKey = $xml->scene[$index]['npc'];
  //echo "<br>npc: $npcKey - ";
  $itemKey = $xml->scene[$index]['item'];
  //echo "item: $itemKey<br>";
  $prompt = "Input a direction (n, e, w, s) or q(uit): ";
  showItem($itemKey);
  showInventory($index);
  $itemKey = $xml->scene[$index]['npc'];
  if($itemKey) {
    showNPC($itemKey);
  }


	
}
function doStage1() {
  global $col;
  global $prompt;
  global $row;
  global $stage;
  global $in;
  global $uname;
  global $xml;
  global $dm;
  
  $dm = "StageIn: $stage ";

  $uname = $in;
  $row = (integer) $xml->player['row'];
  $col = (integer) $xml->player['col'];
  fixPlayerValues();
  $stage = 2;
  $prompt = "s1: $uname, are you happy to play with these values (y/n): "; 
}
function doStage2() {	
  global $stage;
  global $in;
  global $xml;
  global $row;
  global $col;
  global $prompt;
  global $uname;
  global $dm;

  $dm = "StageIn: $stage ";

  if ($in == "y") {
    $stage = 3;
    $prompt = "s2: $uname, press the enter key when ready for the challenge!\n";	
  } else {
	fixPlayerValues();
	$prompt = "s2: $uname, are you happy to play with these values (y/n): "; 
  }
}
function doStage3() {
  global $stage;
  global $xml;
  global $row;
  global $col;
  global $prompt;
  global $in;
  global $dm;

  $dm = "StageIn: $stage ";
	
  $prompt = "s3: Press the enter key when ready for the challenge!\n";
  $stage = 4;


}
function doStage4() {
  global $out;
  global $row;
  global $col;
  global $prompt;
  global $in;
  global $stage;
  global $xml;
  global $dm;

  $dm = "StageIn: $stage ";

  $init = $xml->player->init->desc;
  descToout($init . "\n");
  $prompt = "\nPress the enter key when ready for the challenge!\n";
  $stage = 5;
}
function doStage5() { 
  global $out;
  global $row;
  global $col;
  global $prompt;
  global $in;
  global $stage;
  global $xml;
  global $index;
  global $dm;

  $dm = "StageIn: $stage ";

  $index = getSceneIndex($row, $col, $xml);
  showScene();
  $prompt = "Input a direction (n, e, w, s) or q(uit): ";
  $stage = 6;
}
function doStage6() {
  global $out;
  global $row;
  global $col;
  global $prompt;
  global $in;
  global $stage;
  global $xml;
  global $index;
  global $dm;
  $dm = "StageIn: $stage ";

  
  setNewLocation($in);
  
  $index = getSceneIndex($row, $col, $xml);
  if($index == -1) {
    $index = getSceneIndex(-1, -1, $xml);
    $desc = $xml->scene[$index]->desc;
	descToout($desc);
    //$out =  $desc . "\n";
    $prompt = "Press any key to exit this game. ";
    $stage = 99;
  } else {
    showScene();
    //$prompt = "Input a direction (n, e, w, s) or q(uit): ";
    //$stage = 6;
  }
}
function doStage7 () {
	global $xml;
	global $row;
	global $col;
	global $stage;
	global $inv;
	global $in;
	global $index;
    if ($in == "y") {
        $index = getSceneIndex($row, $col, $xml);
		$itemKey = $xml->scene[$index]['item'];
		//echo "<br>itemKey: $itemKey, index: $index";
		$itemIndex = getItemIndex($itemKey);
		$mask = (integer)$xml->item[$itemIndex]['mask'];
		//echo "<br>itemKey: $itemKey, mask: $mask, itemIndex: $itemIndex";
		$inv = $mask | $inv;
		doStage6();
	} else {
		doStage8();
	}
	//$in = "";
	//$stage = 8;
}
function doStage8(){
  global $stage;
  global $prompt;
  global $in;
  $in = "";
  doStage6();
  
  $stage = 6;
  $prompt = "Input a direction (n, e, w, s) or q(uit): ";
}
function doStage99 () {
	echo "<h2>Thank you for playing this game.</h2>\n";
	echo "<h2>Do please come back for another game!</h2>\n";
	die();
}
switch ($stage) {
    case 1:  doStage1();  break;// entered from intro1.php
    case 2:  doStage2();  break;
    case 3:  doStage3();  break;
    case 4:  doStage4();  break;
    case 5:  doStage5();  break;// first time to show first scene
    case 6:  doStage6();  break;// standard scene showing
    case 7:  doStage7();  break;// handle the taking of an item from current scene
    case 8:  doStage8();  break;// like 6 but no more asking to take item. then 6
    case 99: doStage99(); break;// die
}

//echo "<br>diag: inv $inv, index: $index, row: $row, col: $col, stageOut: $stage, rows: $rows, cols: $cols, ok: $ok\n"; 
?>
<form action="ddd.php" method="post">
<?php
  echoHiddenvalues($uname, $row, $col, $hp, $strength, $inv, $npc, $pt, $stage);
?>
<textarea onclick="run();" id="out" name="out" rows="20" cols="100">
<?php
echo $out;
echo "\n" . $prompt;
?>
</textarea>
<br><br>
<input type="text" id="in" name="in" autofocus><br><br>
</form>

</body>
</html>