/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Fight;
import game.Item;
import game.Player;
import game.Scene;

public class Action {
    public static final int NO_ACTION = 1;
    public static final int PICKUP_ACTION = 2;
    public static final int DEADEND_ACTION = 3;
    public static final int FIGHT_ACTION = 4;
    public static final int WIN_ACTION = 5;
    private int action = 0;
    Scene scene = null;

    public Action(int action, Scene scene) {
        this.action = action;
        this.scene = scene;
    }

    public int doAction(Player player) {
        int status = 0;
        switch (this.action) {
            case 1: {
                status = this.doNoAction(player);
                break;
            }
            case 2: {
                status = this.doPickup(player);
                break;
            }
            case 3: {
                status = this.doDeadEnd(player);
                break;
            }
            case 4: {
                status = this.doFight(player);
                break;
            }
            case 5: {
                status = this.doWin(player);
                break;
            }
            default: {
                System.out.println("Action " + this.action + " Error");
            }
        }
        return status;
    }

    private int doPickup(Player player) {
        Item item = this.scene.item;
        this.scene.item = null;
        if (item != null) {
            player.addItem(item);
            player.health += 20;
        }
        return 0;
    }

    private int doDeadEnd(Player player) {
        player.health -= 20;
        return 0;
    }

    private int doFight(Player player) {
        int status = 0;
        Fight fight = null;
        Item item = this.scene.item;
        if (item != null) {
            fight = new Fight(player, item.title);
            status = fight.run();
        }
        return status;
    }

    private int doWin(Player player) {
        return 3;
    }

    private int doNoAction(Player player) {
        player.health += 10;
        return 0;
    }
}

