/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.Item;
import game.Scene;
import java.util.ArrayList;

public class Player {
    ArrayList<Item> inventory = new ArrayList();
    int health = 100;
    Scene currentScene = null;

    public Player(Scene scene) {
        this.currentScene = scene;
    }

    public void addItem(Item item) {
        this.inventory.add(item);
    }

    public boolean checkForItem(Item item) {
        return this.inventory.contains(item);
    }

    public int move() {
        int status = 0;
        this.printMiniMap(this.currentScene.x, this.currentScene.y);
        if (this.health > 0) {
            System.out.println("Health: " + this.health + "/100 - ");
            System.out.println("Your inventory: " + String.valueOf(this.inventory));
            int input = Game.inputInt("Enter next scene number: ");
            switch (input) {
                case 1: {
                    status = this.goNorth(status);
                    break;
                }
                case 2: {
                    status = this.goEast(status);
                    break;
                }
                case 3: {
                    status = this.goSouth(status);
                    break;
                }
                case 4: {
                    status = this.goWest(status);
                    break;
                }
                default: {
                    System.out.println("Bad Direction number: " + input);
                    break;
                }
            }
        } else {
            status = 2;
        }
        return status;
    }

    private int goNorth(int status) {
        int newX = this.currentScene.x;
        int newY = this.currentScene.y;
        status = --newY < 0 ? 1 : this.enterScene(status, newX, newY);
        return status;
    }

    private int goEast(int status) {
        int newX = this.currentScene.x;
        int newY = this.currentScene.y;
        status = 5 > ++newX ? this.enterScene(status, newX, newY) : 1;
        return status;
    }

    private int goSouth(int status) {
        int newX = this.currentScene.x;
        int newY = this.currentScene.y;
        status = 5 > ++newY ? this.enterScene(status, newX, newY) : 1;
        return status;
    }

    private int goWest(int status) {
        int newX = this.currentScene.x;
        int newY = this.currentScene.y;
        status = --newX < 0 ? 1 : this.enterScene(status, newX, newY);
        return status;
    }

    private int enterScene(int status, int x, int y) {
        this.currentScene = Scene.map[y][x];
        this.health += 10;
        status = this.currentScene.enterScene(this);
        return status;
    }

    void printMiniMap(int x, int y) {
        System.out.println();
        this.printRow1(x, y);
        this.printRow2(x, y);
        this.printRow3(x, y);
    }

    void printRow1(int x, int y) {
        this.printSection("   ", x - 1, y - 1, 1);
        this.printSection("1: ", x, y - 1, 1);
        this.printSection("   ", x + 1, y - 1, 1);
        System.out.println();
        this.printSection("   ", x - 1, y - 1, 2);
        this.printSection("   ", x, y - 1, 2);
        this.printSection("   ", x + 1, y - 1, 2);
        System.out.println();
        this.printSection("   ", x - 1, y - 1, 3);
        this.printSection("   ", x, y - 1, 3);
        this.printSection("   ", x + 1, y - 1, 3);
        System.out.println("\n");
    }

    void printRow2(int x, int y) {
        this.printSection("4: ", x - 1, y, 1);
        this.printSection(" * ", x, y, 1);
        this.printSection("2: ", x + 1, y, 1);
        System.out.println();
        this.printSection("   ", x - 1, y, 2);
        this.printSection(" * ", x, y, 2);
        this.printSection("   ", x + 1, y, 2);
        System.out.println();
        this.printSection("   ", x - 1, y, 3);
        this.printSection(" * ", x, y, 3);
        this.printSection("   ", x + 1, y, 3);
        System.out.println("\n");
    }

    void printRow3(int x, int y) {
        this.printSection("   ", x - 1, y + 1, 1);
        this.printSection("3: ", x, y + 1, 1);
        this.printSection("   ", x + 1, y + 1, 1);
        System.out.println();
        this.printSection("   ", x - 1, y + 1, 2);
        this.printSection("   ", x, y + 1, 2);
        this.printSection("   ", x + 1, y + 1, 2);
        System.out.println();
        this.printSection("   ", x - 1, y + 1, 3);
        this.printSection("   ", x, y + 1, 3);
        this.printSection("   ", x + 1, y + 1, 3);
        System.out.println("\n");
    }

    void printSection(String prefix, int c, int r, int ln) {
        String s = null;
        s = r >= 0 && 5 > r && c >= 0 && 5 > c ? this.printInsideArea(prefix, r, c, ln) : this.printOutsideArea(prefix, r, c, ln);
        this.printFixedWidth(s, 20);
    }

    String printInsideArea(String prefix, int r, int c, int ln) {
        Object s = null;
        switch (ln) {
            case 1: {
                s = prefix + Scene.map[r][c].title;
                break;
            }
            case 2: {
                Item item = Scene.map[r][c].item;
                if (item == null) {
                    s = "                  ";
                    break;
                }
                s = prefix + "(" + item.title + ")";
                break;
            }
            case 3: {
                Item need = Scene.map[r][c].need;
                s = need == null ? " " : prefix + "Need: " + need.title;
            }
        }
        return s;
    }

    String printOutsideArea(String prefix, int r, int c, int ln) {
        Object s = null;
        switch (ln) {
            case 1: {
                s = prefix + "Death Zone     ";
                break;
            }
            case 2: {
                s = " ";
                break;
            }
            case 3: {
                s = " ";
            }
        }
        return s;
    }

    public void printFixedWidth(String s, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        while (sb.length() < width) {
            sb.append(' ');
        }
        System.out.print(sb.toString());
    }
}

