/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Action;
import game.Item;
import game.Player;

public class Scene {
    Action action = null;
    String title = null;
    Item item = null;
    Item need = null;
    String announcement = null;
    public int x = 0;
    public int y = 0;
    public static final int ROWS = 5;
    public static final int COLS = 5;
    public static Scene[][] map = new Scene[5][5];

    public Scene(String title, int action) {
        this.title = title;
        this.action = new Action(action, this);
    }

    public Scene(int row, int col, String title, String ann, int action, Item item, Item need) {
        this(title, action);
        this.announcement = ann;
        this.y = row;
        this.x = col;
        this.item = item;
        this.need = need;
        Scene.map[row][col] = this;
    }

    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    public void setCoordinates(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int enterScene(Player player) {
        int status = 0;
        boolean ok = true;
        if (null != this.announcement) {
            System.out.println("\n" + this.announcement);
        }
        if (null != this.need) {
            ok = player.checkForItem(this.need);
        }
        status = ok ? this.action.doAction(player) : 6;
        return status;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public boolean checkForItem(Item item) {
        return this.item == item;
    }

    public void setNeed(Item item) {
        this.need = item;
    }

    public boolean checkForNeed(Item item) {
        return this.need == item;
    }

    public String toString() {
        return this.title;
    }

    public static void setScenes() {
        Item lamp = new Item("Lamp");
        Item shell = new Item("shell");
        Item sword = new Item("sword");
        Item bear = new Item("bear");
        Item dragon = new Item("dragon");
        String strEdge = "The Cliff's Edge is dangeroun but it had something you need!";
        new Scene(0, 0, "Cliff's Edge", strEdge, 2, lamp, null);
        String strCPath = "The Cobblestone Path connects west, south and east";
        new Scene(0, 1, "Cobblestone Path", strCPath, 1, null, null);
        String strDungeon = "The Dark Dungeion is dark and dangerous wothout a lamp";
        new Scene(0, 2, "Dark Dungeon", strDungeon, 1, null, lamp);
        String strDragon = "I am a big dragon and I will kill you!";
        new Scene(0, 3, "Dark Dungeon", strDragon, 4, dragon, sword);
        String strCastle = "You have achieved your final destination, the Castle!";
        new Scene(0, 4, "Castle", strCastle, 5, null, null);
        String strPlain = "The Grassy Plain is getting close to your end game!";
        new Scene(1, 1, "Grassy Plain", strPlain, 1, null, null);
        String strCross = "I am a wild river and you need a shell to cross me!";
        new Scene(1, 2, "River Crossing", strCross, 1, null, shell);
        String strWoods = "The Enchanted Woods are at the centre of your universe";
        new Scene(2, 2, "Enchanted Woods", strWoods, 1, null, null);
        String strTrail = "I am the Forest Trail and I may be guarded by a little bear";
        new Scene(2, 3, "Forest Trail", strTrail, 4, bear, null);
        String strCottage = "You can take a break in this cottage";
        new Scene(3, 3, "Cottage", strCottage, 2, sword, null);
        String strShore = "You are at the edge of a very large inhospitable lake!";
        new Scene(4, 2, "Lake Shore", strShore, 2, shell, null);
        String strRPath = "I am a very rocky path.  Look for the lake!";
        new Scene(4, 3, "Rocky Path", strRPath, 1, null, null);
        String strRange = "I am an impassable range.  Turn back!";
        new Scene(4, 4, "Mountain Range", strRange, 3, null, null);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 5; ++x) {
                if (map[y][x] != null) continue;
                String str = "You have been shot but maybe still alive!";
                new Scene(y, x, "Off Limits", str, 3, null, null);
            }
        }
    }
}

