/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.CB;
import ge.DD1;
import ge.Log;
import ge.Player;
import ge.RD;
import ge.SM_Map;
import ge.SceneManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class DosSim
extends JPanel
implements CB,
ActionListener {
    private SceneManager sm;
    private SM_Map smmap;
    private static JTextArea textArea;
    private static String back;
    private static Timer timer;
    private static String instructions;
    private static String systemPrompt;
    private static StringBuilder sb;
    private static CB cb;
    private static String xml;
    private static CB wfekcb;
    private static String wfekxml;
    private static String response;
    private String help = "\n?            - display this help\nload         - load game\nrun          - run game\ntest row col - run player\nclear        - clear screen\n";

    public DosSim() {
        Log.mes("DosSim default constructor");
    }

    public DosSim(SceneManager sm, SM_Map smmap) {
        this.smmap = smmap;
        if (smmap == null) {
            Log.mes("DosSim parameterised constructor smmap == null ");
        }
        if (sm == null) {
            Log.mes("DosSim parameterised constructor sm == null");
        }
        this.sm = sm;
        back = "";
        this.setLayout(new BorderLayout());
        textArea = new JTextArea();
        Font f = new Font("Consolas", 1, 18);
        textArea.setFont(f);
        textArea.setBackground(Color.blue);
        textArea.setForeground(Color.WHITE);
        textArea.setText(instructions + systemPrompt);
        back = instructions + systemPrompt;
        textArea.setCaretColor(Color.red);
        textArea.setCaretPosition(textArea.getDocument().getLength());
        JScrollPane scrollPane = new JScrollPane(textArea);
        this.add(scrollPane);
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        timer = new Timer(500, this);
        DosSim.setFocus();
        Log.mes("DosSim parameterised constructor");
    }

    public static void setFocus() {
        textArea.grabFocus();
        timer.start();
    }

    public static void releaseControl() {
        Log.mes("DosSim.releaseControl");
        cb = null;
        DosSim.showPrompt(systemPrompt, null);
    }

    public static void setXML(String xml) {
        DosSim.xml = xml;
    }

    public static void clearWithSystemPrompt() {
        DosSim.clear();
        cb = null;
        DosSim.showPrompt(systemPrompt, new DosSim());
    }

    public static void clear() {
        try {
            sb = new StringBuilder();
            back = "";
            textArea.setText("");
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public static void print(String prompt, CB cb, String xml) {
        Log.mes("DosSim.print cb: " + cb.getName() + ",  xml: <" + xml + ">");
        DosSim.cb = cb;
        DosSim.print(prompt);
        CB cb1 = DosSim.cb;
        DosSim.cb = null;
        cb1.callBack(xml);
    }

    public static void print(String prompt) {
        try {
            back = back + prompt;
            textArea.append(prompt);
            sb = new StringBuilder();
            int newLength = textArea.getDocument().getLength();
            textArea.setCaretPosition(newLength);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public static void wfek(CB cb, String xml) {
        wfekxml = xml;
        wfekcb = cb;
        DosSim cb1 = new DosSim();
        DosSim.ShowPrompt("\nPress Enter key to continue . . .", cb1, null);
    }

    public static void wfek1() {
        CB cb1 = wfekcb;
        String xml1 = wfekxml;
        wfekcb = null;
        wfekxml = null;
        if (cb1 != null) {
            cb1.callBack(xml1);
        }
    }

    public static void ShowPrompt(String prompt, CB cb1, String xml) {
        if (xml != null) {
            DosSim.xml = xml;
        }
        DosSim.showPrompt(prompt, cb1);
    }

    public static void showPrompt(String prompt, CB cb) {
        DosSim.cb = cb;
        DosSim.print(prompt);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.update();
    }

    public void update() {
        String response1;
        String s = textArea.getText();
        if (s.length() < back.length()) {
            DosSim.writeBackToTextArea();
        } else if (s.length() > back.length() && (response1 = s.substring(back.length())).charAt(response1.length() - 1) == '\n') {
            String response = response1.substring(0, response1.length() - 1);
            Log.mes("DosSim.update4 response: <" + response + ">");
            back = s;
            if (cb == null) {
                Log.mes("DosSim.update5 cb == null");
                this.callBack(response);
            } else {
                cb.callBack(response);
            }
        }
        textArea.setCaretPosition(textArea.getDocument().getLength());
    }

    private static void writeBackToTextArea() {
        Log.mes("DosSim.writeBackToTextArea");
        textArea.setText(back);
        textArea.setCaretPosition(textArea.getDocument().getLength());
    }

    @Override
    public void callBack(String response) {
        if (wfekcb != null) {
            DosSim.wfek1();
        } else if (response.equals("?")) {
            DosSim.showPrompt(this.help + systemPrompt, new DosSim());
        } else if (response.length() == 0) {
            DosSim.print(systemPrompt);
        } else if (response.equals("load")) {
            this.loadGame();
        } else if (response.equals("run")) {
            this.runGame();
        } else if (response.equals("clear")) {
            DosSim.clearWithSystemPrompt();
        } else if (response.startsWith("test")) {
            this.runTest(response);
        } else {
            DosSim.showPrompt("I do not understand <" + response + ">\n" + systemPrompt, new DosSim());
        }
    }

    private void loadGame() {
        Log.mes("DosSim.loadGame");
        SceneManager.gameLoaded = RD.readData();
        if (SceneManager.gameLoaded) {
            SM_Map.smmap.populate();
            Log.mes("***Game data read done!");
            DosSim.print("***Game data read done!\n");
        } else {
            Log.mes("***Game data read went wrong!");
            DosSim.print("***Game data read went wrong!\n");
        }
        DosSim.print(systemPrompt);
    }

    private void runGame() {
        Log.mes("DosSim.runGame");
        if (SceneManager.gameLoaded) {
            DD1.phase1();
        } else {
            DosSim.print("Please load game first");
        }
    }

    private void runTest(String response) {
        Log.mes("DosSim.runTest");
        int row = 2;
        int col = 2;
        String[] res = RD.mysplit(response);
        if (res.length == 3) {
            try {
                row = Integer.parseInt(res[1]);
                Log.mes("test row: " + row);
                col = Integer.parseInt(res[2]);
                Log.mes("test col: " + col);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!SceneManager.gameLoaded) {
            this.loadGame();
        }
        Player player = Player.getPlayer();
        player.setRow(row);
        player.setCol(col);
        player.setName("Ed");
        player.es2();
    }

    static {
        instructions = "Please type ? to get possible commands\n";
        systemPrompt = "DosSim V0.1>";
        sb = new StringBuilder();
    }
}

