/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.Choice;
import ge.Desc;
import ge.IO;
import ge.Log;
import ge.RD;
import java.util.HashMap;

public class NPC {
    public HashMap<String, String> data;
    public static HashMap<String, NPC> npcs = new HashMap();
    Desc desc;
    Desc alive;
    Desc dead;
    Choice choice;

    public NPC(String xml) {
        this.data = RD.getDataMap(xml);
        try {
            int hpmax = RD.getIntValue(this.data, "hpmax");
            int hp = (int)(Math.random() * (double)hpmax) + 1;
            RD.putIntDataValue(this.data, "hp", hp);
            int strengthmax = RD.getIntValue(this.data, "strengthmax");
            int strength = (int)(Math.random() * (double)strengthmax) + 1;
            RD.putIntDataValue(this.data, "strength", strength);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setName(String name) {
        try {
            RD.putDataValue(this.data, "name", name);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setDesc(Desc desc) {
        this.desc = desc;
    }

    public void setType(String type) {
        try {
            RD.putDataValue(this.data, "type", type);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setHp(int hp) {
        try {
            RD.putIntDataValue(this.data, "hp", hp);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setStrength(int strength) {
        try {
            RD.putIntDataValue(this.data, "strength", strength);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setPoints(int points) {
        try {
            RD.putIntDataValue(this.data, "points", points);
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public static NPC getNPC(String key) {
        Log.mapNPC("NPC.getNPC key: ", npcs);
        return npcs.get(key);
    }

    public String getName() {
        String name = null;
        try {
            name = this.data.get("name");
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return name;
    }

    public String getKey() {
        String key = null;
        try {
            key = this.data.get("key");
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return key;
    }

    public String getType() {
        String type = null;
        try {
            type = this.data.get("type");
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return type;
    }

    public Desc getDesc() {
        return this.desc;
    }

    public int getHp() {
        int hp = -1;
        try {
            hp = RD.getIntValue(this.data, "hp");
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return hp;
    }

    public int getStrength() {
        int strength = -1;
        try {
            strength = RD.getIntValue(this.data, "strength");
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return strength;
    }

    public int getPoints() {
        return RD.getIntValue(this.data, "points");
    }

    public static void readNPC(IO fr, String xml) {
        Desc desc = null;
        Desc alive = null;
        Desc dead = null;
        String key = null;
        Choice choice = null;
        NPC npc = new NPC(xml);
        key = npc.data.get("key");
        npcs.put(key, npc);
        boolean done = false;
        while (!done) {
            String s = fr.nextLine();
            if (RD.debug) {
                System.out.println("npc line:" + s);
            }
            if (s.startsWith("</npc")) {
                done = true;
                continue;
            }
            if (s.startsWith("<alive")) {
                alive = Desc.readDesc(fr);
                continue;
            }
            if (s.startsWith("<dead")) {
                dead = Desc.readDesc(fr);
                continue;
            }
            if (s.startsWith("<desc")) {
                desc = Desc.readDesc(fr);
                continue;
            }
            if (!s.startsWith("<choice")) continue;
            choice = Choice.readChoice(fr, s);
        }
    }

    public String toString() {
        StringBuilder charDetails = new StringBuilder();
        charDetails.append("The " + this.getKey() + " " + this.getName());
        charDetails.append(" is a " + this.getType() + ", ");
        charDetails.append("has " + this.getHp() + " hit points,");
        charDetails.append(" and " + this.getStrength() + " strength points.\n");
        Desc desc = this.getDesc();
        if (desc != null) {
            charDetails.append(desc.toString());
        }
        return charDetails.toString();
    }
}

