/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.CB;
import ge.Desc;
import ge.DosSim;
import ge.IO;
import ge.Item;
import ge.Log;
import ge.RD;
import ge.Scene;
import java.util.ArrayList;
import java.util.HashMap;

public class Player
implements CB {
    String zz = "Player.";
    public static ArrayList<Player> players = new ArrayList();
    public HashMap<String, String> data;
    static Desc init;
    boolean initFlag = true;
    ArrayList<String> inventory = new ArrayList();

    public Player(String xml) {
        this.data = RD.getDataMap(xml);
        Log.mes("new Player class" + xml);
        players.add(this);
        this.setRandomHp();
        this.setRandomStrength();
    }

    public int getCol() {
        return RD.getIntValue(this.data, "col");
    }

    public HashMap<String, String> getData() {
        Log.mes("Player.getData " + RD.getXML("Player", this.data));
        return this.data;
    }

    public String getGame() {
        return RD.game;
    }

    public int getHp() {
        return RD.getIntValue(this.data, "hp");
    }

    public int getHpMax() {
        return RD.getIntValue(this.data, "hpmax");
    }

    public String getInit() {
        Log.mes("Player.getInit " + init.toString());
        return init.toString();
    }

    @Override
    public String getName() {
        return RD.getValue(this.data, "name");
    }

    public int getRow() {
        return RD.getIntValue(this.data, "row");
    }

    public int getStatus() {
        return RD.getIntValue(this.data, "status");
    }

    public int getStrength() {
        return RD.getIntValue(this.data, "strength");
    }

    public int getStrengthMax() {
        return RD.getIntValue(this.data, "strengthmax");
    }

    public ArrayList<String> getInventory() {
        return this.inventory;
    }

    public void addItem(String item) {
        this.inventory.add(item);
    }

    public int getPoints() {
        return RD.getIntValue(this.data, "points");
    }

    public static Player getPlayer() {
        Player player = null;
        if (!players.isEmpty()) {
            player = players.get(0);
        }
        return player;
    }

    public void setStatus(int status) {
        RD.putIntDataValue(this.data, "status", status);
    }

    public void setName(String name) {
        RD.putDataValue(this.data, "name", name);
    }

    public void setStrength(int strength) {
        RD.putIntDataValue(this.data, "strength", strength);
    }

    public void setRandomStrength() {
        int strengthmax = this.getStrengthMax();
        int strength = (int)(Math.random() * (double)strengthmax) + 1;
        this.setStrength(strength);
    }

    public void setHp(int hp) {
        RD.putIntDataValue(this.data, "hp", hp);
    }

    public void setRandomHp() {
        int hpMax = this.getHpMax();
        int hp = (int)(Math.random() * (double)hpMax) + 1;
        this.setHp(hp);
    }

    public void setPoints(int points) {
        RD.putIntDataValue(this.data, "points", points);
    }

    public void setRow(int row) {
        RD.putIntDataValue(this.data, "row", row);
    }

    public void setCol(int col) {
        RD.putIntDataValue(this.data, "col", col);
    }

    public static void setPlayer(Player player) {
        players.add(player);
    }

    public void startPlayer(Player player) {
        Log.map("Player.enterScene ", this.data);
        if (init != null && this.initFlag) {
            init.print(this, "<next=1>");
            this.initFlag = false;
        } else {
            this.es1();
        }
    }

    private void es1() {
        DosSim.wfek(this, "<wait=es2>");
    }

    public void es2() {
        int row = this.getRow();
        int col = this.getCol();
        Scene.map[row][col].enterScene(Player.getPlayer(), this.data);
    }

    @Override
    public void callBack(String xml) {
        String p1;
        Log.mes("Player.callBack xml: " + xml);
        switch (p1 = RD.getLHS(xml)) {
            case "next": {
                this.es1();
                break;
            }
            case "wait": {
                this.es2();
                break;
            }
            case "move": {
                this.move(xml);
                break;
            }
            case "move2": {
                this.move2(xml);
                break;
            }
            default: {
                Log.mes("Player.callBack default p1: " + p1);
                this.move2(xml);
            }
        }
    }

    public boolean checkForItem(Item item) {
        return this.inventory.contains(item.getKey());
    }

    public void move(String xml) {
        Log.mes("Player.move xml: " + xml);
        if (this.getPoints() > -1) {
            DosSim.print("Points: " + this.getPoints() + "/100 - ");
            DosSim.print("  Your inventory: " + String.valueOf(this.inventory));
            DosSim.setXML("<move2=>");
            int row = this.getRow();
            int col = this.getCol();
            Scene scene = Scene.map[row][col];
            if (scene.getItem() == null) {
                DosSim.showPrompt("\nEnter move direction (n,e,s,w)  or q[uit]): ", this);
            } else {
                DosSim.showPrompt("\nEnter move direction (n,e,s,w), t(ake), or q[uit]): ", this);
            }
        }
    }

    private void takeItem() {
        int col;
        int row = this.getRow();
        Scene scene = Scene.map[row][col = this.getCol()];
        Item item = scene.getItem();
        if (item != null) {
            scene.removeItem(item);
        }
    }

    public void move2(String input) {
        Log.mes("Player.move2: " + input);
        switch (input) {
            case "n": {
                this.goNorth();
                break;
            }
            case "e": {
                this.goEast();
                break;
            }
            case "s": {
                this.goSouth();
                break;
            }
            case "w": {
                this.goWest();
                break;
            }
            case "q": {
                this.setStatus(7);
                break;
            }
            case "t": {
                this.takeItem();
                break;
            }
            default: {
                DosSim.print("Bad Direction: " + input + "  Do please try again!");
            }
        }
        int status = this.getStatus();
        if (status == 0) {
            this.es2();
        } else {
            Log.mes("Player.move2 status: " + status);
            if (status == 7) {
                DosSim.print("Please come back another time!\n");
            } else {
                DosSim.print("You have been killed!\n");
            }
            DosSim.print("Game Over!\n");
            DosSim.releaseControl();
        }
    }

    private void goNorth() {
        int newRow = this.getRow();
        if (--newRow < 0) {
            this.setStatus(1);
        } else {
            this.setRow(newRow);
        }
    }

    private void goEast() {
        int newCol = this.getCol();
        if (RD.cols > ++newCol) {
            this.setCol(newCol);
        } else {
            this.setStatus(1);
        }
    }

    private void goSouth() {
        int newRow = this.getRow();
        if (RD.rows > ++newRow) {
            this.setRow(newRow);
        } else {
            this.setStatus(1);
        }
    }

    private void goWest() {
        int newCol = this.getCol();
        if (--newCol < 0) {
            this.setStatus(1);
        } else {
            this.setCol(newCol);
        }
    }

    void printMap() {
        for (int row = 0; row < RD.rows; ++row) {
            System.out.println("\n");
            for (int col = 0; col < RD.cols; ++col) {
                System.out.print("\t" + Scene.map[row][col].getName());
            }
        }
    }

    void printMiniMap(int x, int y) {
        System.out.println();
        this.printRow1(x, y);
        this.printRow2(x, y);
        this.printRow3(x, y);
    }

    void printRow1(int x, int y) {
        this.printSection("   ", x - 1, y - 1, 1);
        this.printSection("1: ", x, y - 1, 1);
        this.printSection("   ", x + 1, y - 1, 1);
        System.out.println();
        this.printSection("   ", x - 1, y - 1, 2);
        this.printSection("   ", x, y - 1, 2);
        this.printSection("   ", x + 1, y - 1, 2);
        System.out.println();
        this.printSection("   ", x - 1, y - 1, 3);
        this.printSection("   ", x, y - 1, 3);
        this.printSection("   ", x + 1, y - 1, 3);
        System.out.println("\n");
    }

    void printRow2(int x, int y) {
        this.printSection("4: ", x - 1, y, 1);
        this.printSection(" * ", x, y, 1);
        this.printSection("2: ", x + 1, y, 1);
        System.out.println();
        this.printSection("   ", x - 1, y, 2);
        this.printSection(" * ", x, y, 2);
        this.printSection("   ", x + 1, y, 2);
        System.out.println();
        this.printSection("   ", x - 1, y, 3);
        this.printSection(" * ", x, y, 3);
        this.printSection("   ", x + 1, y, 3);
        System.out.println("\n");
    }

    void printRow3(int x, int y) {
        this.printSection("   ", x - 1, y + 1, 1);
        this.printSection("3: ", x, y + 1, 1);
        this.printSection("   ", x + 1, y + 1, 1);
        System.out.println();
        this.printSection("   ", x - 1, y + 1, 2);
        this.printSection("   ", x, y + 1, 2);
        this.printSection("   ", x + 1, y + 1, 2);
        System.out.println();
        this.printSection("   ", x - 1, y + 1, 3);
        this.printSection("   ", x, y + 1, 3);
        this.printSection("   ", x + 1, y + 1, 3);
        System.out.println("\n");
    }

    void printSection(String prefix, int c, int r, int ln) {
        String s = null;
        s = r >= 0 && RD.rows > r && c >= 0 && RD.cols > c ? this.printInsideArea(prefix, r, c, ln) : this.printOutsideArea(prefix, r, c, ln);
        this.printFixedWidth(s, 20);
    }

    String printInsideArea(String prefix, int r, int c, int ln) {
        Object s = null;
        switch (ln) {
            case 1: {
                s = prefix + Scene.map[r][c].getName();
                break;
            }
            case 2: {
                Item item = Scene.map[r][c].getItem();
                if (item == null) {
                    s = "                  ";
                    break;
                }
                s = prefix + "(" + item.getName() + ")";
                break;
            }
            case 3: {
                Item need = Scene.map[r][c].getNeed();
                s = need == null ? " " : prefix + "Need: " + need.getName();
            }
        }
        return s;
    }

    String printOutsideArea(String prefix, int r, int c, int ln) {
        Object s = null;
        switch (ln) {
            case 1: {
                s = prefix + "Death Zone     ";
                break;
            }
            case 2: {
                s = " ";
                break;
            }
            case 3: {
                s = " ";
            }
        }
        return s;
    }

    public void printFixedWidth(String s, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        while (sb.length() < width) {
            sb.append(' ');
        }
        System.out.print(sb.toString());
    }

    public static Desc readInit(IO io) {
        Desc init = null;
        boolean done = false;
        while (!done) {
            String s = io.nextLine();
            if (RD.debug) {
                System.out.println("Player line:" + s);
            }
            if (s.startsWith("<desc")) {
                init = Desc.readDesc(io);
                continue;
            }
            if (!s.startsWith("</init")) continue;
            done = true;
        }
        return init;
    }

    public static void dumpMap() {
        System.out.print("\ndumpMap");
        for (int row = 0; row < RD.rows; ++row) {
            System.out.print("row: " + row + " ");
            for (int col = 0; col < RD.cols; ++col) {
                if (Scene.map[row][col] != null) {
                    System.out.print(" " + Scene.map[row][col].getName());
                    continue;
                }
                System.out.print("   is null");
            }
            System.out.println();
        }
    }

    public static void readPlayer(IO io, String s) {
        Player player = new Player(s);
        Object init = null;
        boolean done = false;
        while (!done) {
            s = io.nextLine();
            if (RD.debug) {
                System.out.println("Player line:" + s);
            }
            if (s.startsWith("</player")) {
                done = true;
                continue;
            }
            if (s.startsWith("<init")) {
                Player.init = Player.readInit(io);
                continue;
            }
            RD.report("Reading Player data  ", io, s);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Player: ");
        sb.append("points: ");
        sb.append(this.getPoints());
        sb.append(", hp:");
        sb.append(this.getHp());
        sb.append(", strength: ");
        sb.append(this.getStrength());
        return sb.toString();
    }
}

