/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.DosSim;
import ge.IO;
import ge.Item;
import ge.Log;
import ge.NPC;
import ge.Player;
import ge.Scene;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RD {
    public static String game;
    public static int rows;
    public static int cols;
    public static boolean debug;
    public static boolean d;
    public static boolean d1;

    public static String getXML(String z, Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(z);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                sb.append(" ");
                sb.append(entry.getKey());
                sb.append("=");
                String s = entry.getValue();
                if (s.contains(" ")) {
                    sb.append("\"");
                    sb.append(s);
                    sb.append("\"");
                    continue;
                }
                sb.append(s);
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static String getItemXML(String z, Map<String, Item> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(z);
        if (map != null) {
            for (Map.Entry<String, Item> entry : map.entrySet()) {
                sb.append(" ");
                sb.append(entry.getKey());
                sb.append("=");
                Item item = entry.getValue();
                sb.append(item.toString());
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public static int getIntValue(HashMap<String, String> map, String key) {
        int value = -1;
        String strValue = map.get(key);
        if (strValue != null) {
            try {
                value = Integer.parseInt(strValue);
            }
            catch (Exception ex) {
                Log.mes("RD.getIntValue key: " + key + ", strValue: " + strValue + ", " + ex.toString());
            }
        } else {
            Log.mes("RD.getIntValue key: " + key + ", map:  " + RD.getXML(key, map));
        }
        return value;
    }

    public static String getValue(HashMap map, String key) {
        Object value = null;
        String strValue = (String)map.get(key);
        return strValue;
    }

    public static String[] mysplit(String s) {
        ArrayList<String> al = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean quotesFlag = false;
        boolean spaceFlag = false;
        boolean transferring = false;
        for (int n = 0; n < s.length(); ++n) {
            char c = s.charAt(n);
            if (c == ' ') {
                if (quotesFlag) {
                    sb.append(c);
                    continue;
                }
                spaceFlag = true;
                transferring = false;
                if (sb.isEmpty()) continue;
                al.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == '\"') {
                if (!quotesFlag) {
                    transferring = true;
                    quotesFlag = true;
                    continue;
                }
                transferring = false;
                quotesFlag = false;
                continue;
            }
            transferring = true;
            sb.append(c);
            if (n < s.length() - 1 || sb.length() <= 0) continue;
            transferring = false;
            al.add(sb.toString());
        }
        String[] s2 = new String[al.size()];
        int i = 0;
        for (String s1 : al) {
            s2[i++] = s1;
        }
        return s2;
    }

    public static HashMap<String, String> getDataMap(String xml) {
        HashMap<String, String> hm = new HashMap<String, String>();
        String pairs = RD.removeAngleBrackets(xml);
        String[] pairStrings = RD.mysplit(pairs);
        try {
            for (String s : pairStrings) {
                String[] pair = s.split("=");
                if (pair.length != 2) continue;
                hm.put(pair[0], pair[1]);
            }
            if (d) {
                for (Map.Entry entry : hm.entrySet()) {
                    System.out.println((String)entry.getKey() + " = " + (String)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return hm;
    }

    public static void putDataValue(HashMap<String, String> data, String key, String value) {
        try {
            data.put(key, value);
        }
        catch (Exception ex) {
            System.out.println("key: " + key + " = value" + value + " - " + ex.toString());
        }
    }

    public static void putIntDataValue(HashMap<String, String> data, String key, int intValue) {
        try {
            String strValue = String.valueOf(intValue);
            data.put(key, strValue);
        }
        catch (Exception ex) {
            System.out.println("key: " + key + " = value" + intValue + " - " + ex.toString());
        }
    }

    public static String removeAngleBrackets(String s) {
        char c;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (i < s.length() && (c = s.charAt(i++)) != '>') {
            if (c == '<') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getLHS(String s) {
        s = RD.removeAngleBrackets(s);
        String[] d = s.split("=");
        return d[0];
    }

    public static String getRHS(String s) {
        String[] d = null;
        String answer = null;
        String s1 = null;
        try {
            s1 = RD.removeAngleBrackets(s);
            d = s1.split("=");
            if (d.length > 1) {
                answer = d[1];
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println("s: -" + s + "-");
            System.out.println("s1: -" + s1 + "-");
        }
        return answer;
    }

    public static int[] getRHSints(String s) {
        int[] da = new int[2];
        String[] sa = RD.getRHS(s).split(",");
        try {
            da[0] = Integer.parseInt(sa[0]);
            da[1] = Integer.parseInt(sa[1]);
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return da;
    }

    public static int getRHSint(String s) {
        int answer = 0;
        String s1 = RD.getRHS(s);
        try {
            answer = Integer.parseInt(s1);
        }
        catch (Exception e) {
            Log.mes(e);
        }
        return answer;
    }

    public static void readGame(String s) {
        game = RD.getRHS(s);
        DosSim.print("Reading Game: " + game + "\n");
    }

    public static String readName(String s) {
        String name = RD.getRHS(s);
        return name;
    }

    public static void readDimensions(String s) {
        int[] dimensions = RD.getRHSints(s);
        rows = dimensions[0];
        cols = dimensions[1];
        DosSim.print("This game has " + rows + " rows and " + cols + " columns.\n");
        Scene.map = new Scene[rows][cols];
    }

    public static void report(String rep, IO input, String s) {
        Log.mes("***Report: " + rep + " on line " + input.getLineNumber() + ", s: <" + s + ">");
    }

    public static void readData1(String s, IO io) {
        try {
            if (s.startsWith("<")) {
                if (s.startsWith("<game")) {
                    RD.readGame(s);
                }
                if (s.startsWith("<dimensions")) {
                    RD.readDimensions(s);
                } else if (s.startsWith("<npc")) {
                    NPC.readNPC(io, s);
                } else if (s.startsWith("<scene")) {
                    Scene.readScene(io, s);
                } else if (s.startsWith("<item")) {
                    Item.readItem(io, s);
                } else if (s.startsWith("<player")) {
                    Player.readPlayer(io, s);
                }
            }
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public static boolean readData1(IO input) {
        DosSim.print("opened \n");
        boolean done = false;
        try {
            while (input.hasNextLine() && !done) {
                String s = input.nextLine();
                if (debug) {
                    System.out.println("RD line" + input.getLineNumber() + ": " + s);
                }
                if (s.startsWith("#") || s.length() <= 0) continue;
                if (s.startsWith("</game")) {
                    done = true;
                    continue;
                }
                RD.readData1(s, input);
            }
            input.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            Log.mes(e);
        }
        return done;
    }

    public static boolean readData() {
        IO input = null;
        boolean status = false;
        boolean done = false;
        try {
            input = new IO();
            status = RD.readData1(input);
        }
        catch (Exception e) {
            Log.mes("RD.readData " + e.toString());
        }
        Log.mes("RD.readData return status: " + status);
        return status;
    }

    static {
        debug = false;
        d = false;
        d1 = false;
    }
}

