/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.Log;
import ge.Player;
import ge.RD;
import ge.Scene;
import ge.SceneManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SM_EditPlayer
extends JPanel
implements ActionListener {
    JTabbedPane tabs1;
    JTextArea desc;
    JTextField txtRow;
    JTextField txtCol;
    JTextField txtItem;
    JTextField txtInv;
    JTextField txtNPC;
    JTextField txtXML;
    JTextField txtButtonResponse;
    JTextField txtGame;
    JTextField txtMaxRows;
    JTextField txtMaxCols;
    JTextField txtName;
    JTextField txtWin;
    JLabel lblRow;
    JLabel lblCol;
    JButton jbN;
    JButton jbE;
    JButton jbS;
    JButton jbW;
    JButton jbQ;
    JButton jbLoad;
    JButton jbSave;
    Scene scene;

    SM_EditPlayer(JTabbedPane tabs) {
        this.setLayout(new BorderLayout());
        this.fixNorthPanel();
        this.fixCenterPanel();
        this.fixSouthPanel();
        this.tabs1 = tabs;
    }

    private void fixNorthPanel() {
        JPanel jp = new JPanel();
        this.fixPositionDisplay(jp);
        this.txtGame = new JTextField(20);
        jp.add(this.txtGame);
        this.txtName = new JTextField("Player name goes here");
        Font f = this.txtName.getFont();
        Font f1 = new Font(f.getName(), 1, 24);
        this.txtName.setFont(f1);
        jp.add(this.txtName);
        this.add((Component)jp, "North");
    }

    private void fixPositionDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblRow = new JLabel("Row:");
        this.txtRow = new JTextField(2);
        JLabel lblCol = new JLabel("Col:");
        this.txtCol = new JTextField(2);
        jp.add(lblRow);
        jp.add(this.txtRow);
        jp.add(lblCol);
        jp.add(this.txtCol);
        JLabel lblMaxRow = new JLabel("Max Row:");
        this.txtMaxRows = new JTextField(2);
        JLabel lblMaxCol = new JLabel("Max Col:");
        this.txtMaxCols = new JTextField(2);
        jp.add(lblMaxRow);
        jp.add(this.txtMaxRows);
        jp.add(lblMaxCol);
        jp.add(this.txtMaxCols);
        jp1.add(jp);
    }

    private void fixCenterPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.fixInventoryDisplay(jp);
        this.desc = new JTextArea(6, 50);
        JScrollPane jsp = new JScrollPane(this.desc);
        Font f = this.desc.getFont();
        Font f1 = new Font(f.getName(), 0, 16);
        this.desc.setFont(f1);
        jp.add(jsp);
        this.fixXMLDisplay(jp);
        this.add((Component)jp, "Center");
    }

    private void fixInventoryDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblInv = new JLabel("  Inventory:");
        this.txtInv = new JTextField(50);
        jp.add(lblInv);
        jp.add(this.txtInv);
        jp1.add((Component)jp, "North");
    }

    private void fixXMLDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblXML = new JLabel("  XML:");
        this.txtXML = new JTextField(60);
        jp.add(lblXML);
        jp.add(this.txtXML);
        jp1.add((Component)jp, "South");
    }

    private void fixSouthPanel() {
        JPanel jp = new JPanel();
        this.txtButtonResponse = new JTextField(40);
        jp.add(this.txtButtonResponse);
        this.fixNavButtons(jp);
        this.add((Component)jp, "South");
    }

    private void fixNavButtons(JPanel jp1) {
        JPanel jp = new JPanel();
        JButton jb = new JButton("some text");
        Font f = jb.getFont();
        Font f1 = new Font(f.getName(), 1, 24);
        this.fixButton(jp, "Load", f1);
        this.fixButton(jp, "Save", f1);
        this.fixButton(jp, "N", f1);
        this.fixButton(jp, "E", f1);
        this.fixButton(jp, "S", f1);
        this.fixButton(jp, "W", f1);
        jp1.add(jp);
    }

    private void fixButton(JPanel jp, String text, Font f1) {
        JButton jb = new JButton(text);
        jb.setFont(f1);
        jb.addActionListener(this);
        jp.add(jb);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (SceneManager.gameLoaded) {
            Object o = ae.getSource();
            if (o instanceof JButton) {
                JButton b = (JButton)o;
                String label = b.getText();
                Player player = Player.getPlayer();
                int row = player.getRow();
                int col = player.getCol();
                if (label.equals("N")) {
                    if (row > 0) {
                        this.changeScene(--row, col);
                    }
                } else if (label.equals("E")) {
                    if (col < RD.cols - 1) {
                        this.changeScene(row, ++col);
                    }
                } else if (label.equals("S")) {
                    if (row < RD.rows - 1) {
                        ++row;
                    }
                    this.changeScene(row, col);
                } else if (label.equals("W")) {
                    if (col > 0) {
                        this.changeScene(row, --col);
                    }
                } else if (label.equals("Load")) {
                    this.loadData();
                } else if (label.equals("Save")) {
                    this.savePlayer();
                }
            }
        } else {
            this.txtButtonResponse.setText("Please first load game");
        }
    }

    private void changeScene(int row, int col) {
        try {
            Player player = Player.getPlayer();
            player.setRow(row);
            player.setCol(col);
            this.loadPlayerData(player);
        }
        catch (Exception e) {
            Log.mes("SM_EditPlayer.changeScene " + e.toString());
        }
    }

    private void loadPlayerData(Player player) {
        try {
            HashMap<String, String> map = player.getData();
            String xml = RD.getXML("player", map);
            this.txtXML.setText(xml);
            this.fixInit();
            this.txtGame.setText(player.getGame());
            this.txtRow.setText(String.valueOf(player.getRow()));
            this.txtCol.setText(String.valueOf(player.getCol()));
            if (player.getName() != null) {
                this.txtName.setText(player.getName());
            }
            this.txtMaxRows.setText(String.valueOf(RD.rows));
            this.txtMaxCols.setText(String.valueOf(RD.cols));
            this.txtRow.setText(String.valueOf(player.getRow()));
            this.txtCol.setText(String.valueOf(player.getCol()));
        }
        catch (Exception e) {
            Log.mes("SM_EditPlayer.changeScene " + e.toString());
        }
    }

    private void fixInit() {
        Player player = Player.getPlayer();
        String desc1 = player.getInit();
        if (desc1 != null) {
            this.desc.setText(desc1);
        } else {
            this.desc.setText("");
        }
    }

    private void fixXMLData() {
        if (SceneManager.gameLoaded) {
            Player player = Player.getPlayer();
            if (player != null) {
                HashMap<String, String> data = this.scene.getData();
                if (data != null) {
                    String s = RD.getXML("scene", data);
                    this.txtXML.setText(s);
                } else {
                    this.txtXML.setText("");
                    this.txtButtonResponse.setText("SM_EditScene.enterScene xml: = null");
                    Log.mes("SM_EditScene.enterScene xml: = null");
                }
            } else {
                this.txtButtonResponse.setText("SM_EditPlayer null player");
                Log.mes("SM_EditPlayer null player");
            }
        } else {
            this.txtButtonResponse.setText("game not loaded");
            Log.mes("SM_EditPlayer fixData game not loaded");
        }
    }

    private void loadData() {
        try {
            Player player = Player.getPlayer();
            this.loadPlayerData(player);
        }
        catch (Exception e) {
            Log.mes("SM_EditPlayer.changeScene " + e.toString());
        }
    }

    private void savePlayer() {
        String xml = this.txtXML.getText();
        Player player = null;
        if (xml.length() > 0) {
            player = new Player(xml);
        } else {
            this.txtButtonResponse.setText("No player to save, you must first load or set some data for player");
        }
    }
}

