/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.Desc;
import ge.Item;
import ge.Log;
import ge.NPC;
import ge.RD;
import ge.Scene;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SM_EditScene
extends JPanel
implements ActionListener {
    JTabbedPane tabs1;
    JTextArea desc;
    JTextField txtRow;
    JTextField txtCol;
    JTextField txtItem;
    JTextField txtNeed;
    JTextField txtNPC;
    JTextField txtXML;
    JLabel lblName;
    JLabel lblRow;
    JLabel lblCol;
    JButton jbN;
    JButton jbE;
    JButton jbS;
    JButton jbW;
    JButton jbQ;
    JButton jbLoad;
    JButton jbSave;
    Scene scene;

    SM_EditScene(JTabbedPane tabs) {
        this.setLayout(new BorderLayout());
        this.fixNorthPanel();
        this.fixCenterPanel();
        this.fixSouthPanel();
        this.tabs1 = tabs;
    }

    private void fixNorthPanel() {
        JPanel jp = new JPanel();
        this.fixPositionDisplay(jp);
        this.lblName = new JLabel("Scene name goes here");
        Font f = this.lblName.getFont();
        Font f1 = new Font(f.getName(), 1, 24);
        this.lblName.setFont(f1);
        jp.add(this.lblName);
        this.add((Component)jp, "North");
    }

    private void fixPositionDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblRow = new JLabel("Row:");
        this.txtRow = new JTextField(2);
        JLabel lblCol = new JLabel("Col:");
        this.txtCol = new JTextField(2);
        jp.add(lblRow);
        jp.add(this.txtRow);
        jp.add(lblCol);
        jp.add(this.txtCol);
        jp1.add(jp);
    }

    private void fixCenterPanel() {
        JPanel jp = new JPanel();
        this.desc = new JTextArea(6, 50);
        Font f = this.desc.getFont();
        Font f1 = new Font(f.getName(), 0, 16);
        this.desc.setFont(f1);
        jp.add(this.desc);
        this.fixItemDisplay(jp);
        this.fixNeedDisplay(jp);
        this.fixNPCDisplay(jp);
        this.add(jp);
    }

    private void fixNeedDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblNeed = new JLabel("  Need:");
        this.txtNeed = new JTextField(50);
        jp.add(lblNeed);
        jp.add(this.txtNeed);
        jp1.add(jp);
    }

    private void fixItemDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblItem = new JLabel("  Item:");
        this.txtItem = new JTextField(50);
        jp.add(lblItem);
        jp.add(this.txtItem);
        jp1.add(jp);
    }

    private void fixNPCDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblNPC = new JLabel("  NPC:");
        this.txtNPC = new JTextField(50);
        jp.add(lblNPC);
        jp.add(this.txtNPC);
        jp1.add(jp);
    }

    private void fixSouthPanel() {
        JPanel jp = new JPanel();
        this.fixXMLDisplay(jp);
        this.fixNavButtons(jp);
        this.add((Component)jp, "South");
    }

    private void fixXMLDisplay(JPanel jp1) {
        JPanel jp = new JPanel();
        JLabel lblXML = new JLabel("  XML:");
        this.txtXML = new JTextField(40);
        jp.add(lblXML);
        jp.add(this.txtXML);
        jp1.add(jp);
    }

    private void fixNavButtons(JPanel jp1) {
        JPanel jp = new JPanel();
        JButton jb = new JButton("some text");
        Font f = jb.getFont();
        Font f1 = new Font(f.getName(), 1, 24);
        this.fixButton(jp, "Load", f1);
        this.fixButton(jp, "Save", f1);
        this.fixButton(jp, "N", f1);
        this.fixButton(jp, "E", f1);
        this.fixButton(jp, "S", f1);
        this.fixButton(jp, "W", f1);
        jp1.add(jp);
    }

    private void fixButton(JPanel jp, String text, Font f1) {
        JButton jb = new JButton(text);
        jb.setFont(f1);
        jb.addActionListener(this);
        jp.add(jb);
    }

    public void enterScene(String xml) {
        HashMap<String, String> hm = RD.getDataMap(xml);
        int row = RD.getIntValue(hm, "row");
        int col = RD.getIntValue(hm, "col");
        this.scene = Scene.map[row][col];
        this.lblName.setText(this.scene.getName());
        this.fixDesc();
        this.fixNeed();
        this.fixItem();
        this.fixNPC();
        this.fixData();
        this.txtRow.setText(String.valueOf(this.scene.getRow()));
        this.txtCol.setText(String.valueOf(this.scene.getCol()));
        HashMap<String, String> data = this.scene.getData();
        if (data != null) {
            String s = RD.getXML("scene", data);
            this.txtXML.setText(s);
        }
        this.tabs1.setSelectedComponent(this);
    }

    private void fixDesc() {
        Desc desc1 = this.scene.getDesc();
        if (desc1 != null) {
            this.desc.setText(desc1.toString());
        } else {
            this.desc.setText("");
        }
    }

    private void fixNeed() {
        if (this.scene.getNeed() != null) {
            Item need = this.scene.getNeed();
            this.txtNeed.setText(need.toString());
        } else {
            this.txtNeed.setText("");
        }
    }

    private void fixItem() {
        if (this.scene.getItem() != null) {
            Item item = this.scene.getItem();
            this.txtItem.setText(item.toString());
        } else {
            this.txtItem.setText("");
        }
    }

    private void fixNPC() {
        if (this.scene.getNPC() != null) {
            NPC npc = this.scene.getNPC();
            this.txtNPC.setText(npc.toString());
        } else {
            this.txtNPC.setText("");
        }
    }

    private void fixData() {
        HashMap<String, String> data = this.scene.getData();
        if (data != null) {
            String s = RD.getXML("scene", data);
            this.txtXML.setText(s);
        } else {
            this.txtXML.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o instanceof JButton) {
            JButton b = (JButton)o;
            String label = b.getText();
            int row = this.scene.getRow();
            int col = this.scene.getCol();
            if (label.equals("N")) {
                if (row > 0) {
                    --row;
                }
            } else if (label.equals("E")) {
                if (col < RD.cols - 1) {
                    ++col;
                }
            } else if (label.equals("S")) {
                if (row < RD.rows - 1) {
                    ++row;
                }
            } else if (label.equals("W") && col > 0) {
                --col;
            }
            try {
                Scene newScene = Scene.map[row][col];
                HashMap<String, String> map = newScene.getData();
                String xml = RD.getXML("scene", map);
                this.enterScene(xml);
            }
            catch (Exception ex) {
                Log.mes(ex);
            }
        }
    }
}

