/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.Item;
import ge.Log;
import ge.NPC;
import ge.RD;
import ge.SM_EditScene;
import ge.Scene;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SM_Map
extends JPanel
implements ActionListener {
    static SM_Map smmap;
    SM_EditScene editScene = null;
    JTabbedPane tabs = null;
    JButton jbDisplayPanel;
    JPanel displayPanel;

    SM_Map(SM_EditScene editScene, JTabbedPane tabs) {
        smmap = this;
        this.editScene = editScene;
        this.tabs = tabs;
        this.setLayout(new BorderLayout());
        this.addTopPanel();
        this.displayPanel = this.getDisplayPanel();
        this.add(this.displayPanel);
    }

    private void addTopPanel() {
        JPanel bp = new JPanel();
        JLabel lblGame = new JLabel(RD.game);
        Font f = lblGame.getFont();
        Font f1 = new Font(f.getName(), 1, 28);
        lblGame.setFont(f1);
        bp.add(lblGame);
        this.add((Component)bp, "North");
    }

    private JPanel getDisplayPanel() {
        JPanel bp = new JPanel();
        return bp;
    }

    public void populate() {
        try {
            this.displayPanel.setLayout(new GridLayout(RD.rows, RD.cols));
            for (int row = 0; row < RD.rows; ++row) {
                for (int col = 0; col < RD.cols; ++col) {
                    Item need;
                    Item item;
                    Scene scene = Scene.map[row][col];
                    if (scene == null) continue;
                    JPanel jp1 = new JPanel();
                    String name = scene.getName();
                    String html = "<html><bold>" + name + "</bold>";
                    NPC npc = scene.getNPC();
                    if (npc != null) {
                        html = html + "<br>npc: " + npc.getKey();
                    }
                    if ((item = scene.getItem()) != null) {
                        html = html + "<br>has " + item.getKey();
                    }
                    if ((need = scene.getNeed()) != null) {
                        html = html + "<br>needs " + need.getKey();
                    }
                    this.jbDisplayPanel = new JButton(html);
                    String xml = RD.getXML("Scene", scene.getData());
                    this.jbDisplayPanel.setActionCommand(xml);
                    this.displayPanel.add(this.jbDisplayPanel);
                    this.jbDisplayPanel.addActionListener(this);
                }
            }
        }
        catch (Exception ex) {
            Log.mes(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o instanceof JButton) {
            JButton jb = (JButton)o;
            String xml = jb.getActionCommand();
            this.editScene.enterScene(xml);
        }
    }
}

