/*
 * Decompiled with CFR 0.152.
 */
package ge;

import ge.CB;
import ge.Desc;
import ge.DosSim;
import ge.IO;
import ge.Item;
import ge.Log;
import ge.NPC;
import ge.Player;
import ge.RD;
import java.util.HashMap;

public class Scene
implements CB {
    private final HashMap<String, String> data;
    private HashMap<String, String> playerData;
    private Player player;
    private int status;
    Desc desc;
    Desc ext;
    Desc exte;
    Desc exts;
    Desc extw;
    Desc extn;
    Desc exit;
    public static Scene[][] map;

    public Scene(String xml) {
        this.data = RD.getDataMap(xml);
    }

    public int enterScene(Player player, HashMap<String, String> playerData) {
        this.playerData = playerData;
        this.player = player;
        try {
            boolean ok = true;
            DosSim.clear();
            DosSim.print("row: " + this.getRow() + ", col: " + this.getCol() + "\n");
            if (null != this.desc) {
                this.desc.print(this, "<next=es1>");
            }
        }
        catch (Exception ex) {
            Log.mes(ex);
        }
        return this.status;
    }

    private int es1() {
        try {
            DosSim.print("\n");
            if (this.getNPC() != null) {
                DosSim.print(this.getNPC().toString() + "\n");
            }
            if (this.getItem() != null) {
                DosSim.print(this.getItem().toString() + "\n");
            }
            if (null != this.getNeed()) {
                DosSim.print(" Needs: " + this.getNeed().toString() + "\n");
            }
            if (this.getDie() != 0) {
                this.status = this.getDie();
            } else if (this.getWin() > 0) {
                this.status = this.getWin();
            }
            this.player.callBack("<move=>");
        }
        catch (Exception ex) {
            Log.mes(ex);
        }
        return this.status;
    }

    @Override
    public void callBack(String xml) {
        String next;
        Log.mes("Scene.callBack xml: " + xml);
        switch (next = RD.getRHS(xml)) {
            case "es1": {
                this.es1();
                break;
            }
            default: {
                Log.mes("Scene.callBack default");
            }
        }
    }

    public HashMap<String, String> getData() {
        if (this == null) {
            return null;
        }
        return this.data;
    }

    public void setExit(Desc exit) {
        if (this == null) {
            return;
        }
        this.exit = exit;
    }

    public void setDesc(Desc desc) {
        if (this == null) {
            return;
        }
        this.desc = desc;
    }

    @Override
    public String getName() {
        if (this == null) {
            return null;
        }
        return this.data.get("name");
    }

    public Desc getDesc() {
        if (this == null) {
            return null;
        }
        return this.desc;
    }

    public NPC getNPC() {
        if (this == null) {
            return null;
        }
        NPC npc = null;
        String strNPC = this.data.get("npc");
        if (strNPC != null && strNPC.length() > 0) {
            npc = NPC.npcs.get(strNPC);
        }
        return npc;
    }

    public Item getItem() {
        if (this == null) {
            return null;
        }
        Item item = null;
        String strItem = this.data.get("item");
        if (strItem != null && strItem.length() > 0) {
            item = Item.items.get(strItem);
        }
        return item;
    }

    public void removeItem(Item item) {
        if (this == null) {
            return;
        }
        String key = item.getKey();
        Log.mes("Scene.removeItem key: " + key);
        String strItem = this.data.remove("item");
        if (strItem == null) {
            Log.mes("Scene.removeItem returns null for key: " + key);
        } else {
            this.player.addItem(key);
        }
    }

    public Item getNeed() {
        if (this == null) {
            return null;
        }
        Item need = null;
        String strNeed = this.data.get("need");
        if (strNeed != null && strNeed.length() > 0) {
            need = Item.items.get(strNeed);
        }
        return need;
    }

    public int getRow() {
        if (this == null) {
            return -1;
        }
        return RD.getIntValue(this.data, "row");
    }

    public int getCol() {
        if (this == null) {
            return -1;
        }
        return RD.getIntValue(this.data, "col");
    }

    public int getDie() {
        if (this == null) {
            return -1;
        }
        String strDie = this.data.get("die");
        int die = 0;
        try {
            if (strDie != null && strDie.length() > 0) {
                die = Integer.parseInt(strDie);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return die;
    }

    public int getWin() {
        if (this == null) {
            return -1;
        }
        String strWin = this.data.get("win");
        int win = 0;
        try {
            if (strWin != null && strWin.length() > 0) {
                win = Integer.parseInt(strWin);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return win;
    }

    private static void fillMissingScenes(String name, Desc desc, IO io) {
        try {
            Log.mes("fillMissingScenes about to set up ");
            Scene scene = null;
            for (int row = 0; row < RD.rows; ++row) {
                for (int col = 0; col < RD.cols; ++col) {
                    if (map[row][col] != null) continue;
                    StringBuilder xml = new StringBuilder();
                    xml.append("<scene name=default row=");
                    xml.append(row);
                    xml.append(" col=");
                    xml.append(col);
                    xml.append(">");
                    Scene.map[row][col] = scene = new Scene(xml.toString());
                }
            }
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public static void readScene(IO fr, String s) {
        try {
            Scene scene = new Scene(s);
            boolean done = false;
            while (!done) {
                s = fr.nextLine();
                if (s.length() <= 0) continue;
                if (RD.debug) {
                    Log.mes("scene line" + fr.getLineNumber() + ": " + s);
                }
                if (s.startsWith("<desc")) {
                    scene.desc = Desc.readDesc(fr);
                    continue;
                }
                if (s.startsWith("<exit")) {
                    scene.setExit(Desc.readDesc(fr));
                    continue;
                }
                if (scene.getName().equals("default")) {
                    Scene.fillMissingScenes(scene.getName(), scene.desc, fr);
                    done = true;
                    continue;
                }
                if (s.startsWith("</scene")) {
                    done = true;
                    Scene.map[scene.getRow()][scene.getCol()] = scene;
                    continue;
                }
                RD.report("Bad Scene tag", fr, s);
            }
        }
        catch (Exception e) {
            Log.mes(e);
        }
    }

    public String toString() {
        int win;
        Item item;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append(", row: ");
        sb.append(this.getRow());
        sb.append(", col: ");
        sb.append(this.getCol());
        NPC npc = this.getNPC();
        if (npc != null) {
            sb.append(", npc: ");
            sb.append(npc.getKey());
        }
        if ((item = this.getItem()) != null) {
            sb.append(", item: ");
            sb.append(item.getKey());
        }
        if ((win = this.getWin()) > 0) {
            sb.append(", win! ");
        }
        sb.append("\n\n");
        sb.append(this.desc.toString());
        return sb.toString();
    }
}

