package ge;

import java.util.*;

/**
 *
 * @author eddie
 */
class Choice {

    String prompt;
    ArrayList<Option> options;

    public Choice(String prompt, ArrayList<Option> options) {
        this.prompt = prompt;
        this.options = options;
    }

    public static Choice readChoice(IO fr, String s) {
        String prompt = null;
        Choice choice = null;
        ArrayList<Option> options = new ArrayList<>();
        String type = null;
        prompt = RD.getRHS(s);
        if (prompt == null) {
            RD.report("Choice without prompt", fr, s);
        }
        boolean done = false;
        while (!done) {
            s = fr.nextLine();
            if (RD.debug) {
                System.out.println("choice line:" + s);// diagnostic
            }
            if (s.startsWith("</choice")) {
                if (!options.isEmpty()) {
                    choice = new Choice(prompt, options);
                    if (RD.d) {
                        System.out.println("print choice");// diagnostic
                        System.out.println(choice);
                    }
                }
                done = true;
            } else {
                options.add(Option.readOption(fr, s));
            }
        }// end while ! done
        return choice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int optionQty = options.size();
        sb.append("Choice contains ");
        sb.append(optionQty);
        sb.append(" options. \n");
        for (Option option : options) {
            sb.append(option.toString());
        }
        return sb.toString();
    }
}
