package ge;

import java.util.ArrayList;
import javax.swing.*;
import java.awt.event.*;
/**
 *
 * @author eddie
 */
public class Desc implements CB{
  /**
   * cb - call back address
   */
    CB cb; 
    String xml;
    ArrayList<String> txt;
    String name = "desc";

    public Desc(ArrayList<String> txt) {
        this.txt = txt;
    }

    public String getName(){
      return name + " " +  txt.get(0).substring(0, 10);
    }
    
    
    public void print(CB cb, String xml) {
      //Log.mes ("Desc.print xml: " + xml + ", from " + cb.getName());
      this.cb = cb;
      this.xml = xml;
      print2(0);
    }

    
    private void print2(int index) {
        String xml = null;
       // Log.mes ("Desc.print2 index: " + index + "   txt.size():" + txt.size());
        if (index < txt.size()) {
           String line = txt.get(index);  
            if (line.startsWith("<")){
                runCommand(line);
            } else {
                if (line.contains("<playerName>")){
                    String name = Player.players.get(0).getName();
                    line = line.replace("<playerName>", name);
                }
                DosSim.print(line + "\n");
            } 
            xml = "<next=" + String.valueOf(index + 1) + ">";
            Delay delay = new Delay(10, xml, this);
 
        } else {             // the print is done!
         // Log.mes("Desc.print2 the print is done for this desc!");
          if(cb != null) {
             CB cb1 = cb;
            cb = null;
            cb1.callBack (this.xml);
          }
        }

    }
    
    
    public void callBack(String xml){
        int index = RD.getRHSint(xml);
       // Log.mes("Desc.callBack " + xml + ", index = " + index);
        print2(index);

    }
    private void runCommand(String s) {
        if (s.startsWith("<clear")) {
            clear();
        } else if (s.startsWith("<sleep")) {
            sleep(s);
        } else if (s.startsWith("<br")) {
            DosSim.print("\n");
        }

    }

    private void clear() {
        //System.out.print("\033[H\033[2J");
        DosSim.clear();
    }

    
    /**
     * called from loading game, interpreting <sleep=999>
     * @param s - the xml input
     */
    private void sleep(String s) {
        int ms = RD.getRHSint(s);
        sleep(ms);
    }

    public static void sleep(int ms) {
      try{
       // Log.mes("Desc sleep ms: " + ms);
        Thread.sleep(ms);
       // Log.mes("Desc sleep done ");
        } catch (Exception e) {
        }
      }

    public static void sleep1(int ms) {
       Delay delay = null;
        try {
            delay = new Delay();
            delay.startDelay(ms);
            boolean done = false;
            Log.mes("Desc.sleep1 ");
            while(delay.getTimer().isRunning()){
                 //Thread.sleep(ms);
            }
            Log.mes("Desc.sleep2 ");
        } catch (Exception e) {
        }

    }

    public static Desc readDesc(IO fr) {
        Desc desc = null;
        ArrayList<String> al = new ArrayList<>();
        boolean done = false;
        try {
            while (!done) {
                String s = fr.nextLine();
                if (RD.debug) {
                    System.out.println(s);
                }
                if (!s.startsWith("</desc")) {
                    al.add(s);
                } else {
                    desc = new Desc(al);
                    done = true;
                }
            }
        } catch (Exception e) {
            System.out.println("readDesc " + e.toString());
        }
        return desc;
    }

    public static Desc readDesc(IO fr, String finish) {
        Desc desc = null;
        ArrayList<String> al = new ArrayList<>();
        boolean done = false;
        try {
            while (!done) {
                String s = fr.nextLine();
                if (RD.debug) {
                    System.out.println(s);
                }
                if (!s.startsWith(finish)) {
                    al.add(s);
                } else {
                    desc = new Desc(al);
                    done = true;
                }
            }
        } catch (Exception e) {
            System.out.println("readDesc " + e.toString());
        }
        return desc;
    }

    /**
     * toString only a diagnostic as embedded commands will not operate
     * <br> use print instead
     *
     * @return the description including embedded commands
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : txt) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

}
