package ge;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/**
 *
 * @author eddie
 */
public class DosSim extends JPanel
        implements CB, ActionListener {

  private SceneManager sm;
  private SM_Map smmap;

  private static JTextArea textArea;
  private static String back;
  private static javax.swing.Timer timer;
  private static String instructions = "Please type ? to get possible commands\n";
  private static String systemPrompt = "DosSim V0.1>";
  private static StringBuilder sb = new StringBuilder();

  private static CB cb; // call back after prompt
  private static String xml;
  private static CB wfekcb;
  private static String wfekxml;

  public DosSim() {
    Log.mes("DosSim default constructor");
  }

  public DosSim(SceneManager sm, SM_Map smmap) {
    this.smmap = smmap;
    if (smmap == null)
      Log.mes("DosSim parameterised constructor smmap == null ");
    if (sm == null)
      Log.mes("DosSim parameterised constructor sm == null");

    this.sm = sm;
    back = "";

    setLayout(new BorderLayout());
    textArea = new JTextArea();
    Font f = new Font("Consolas", Font.BOLD, 18);
    textArea.setFont(f);
    textArea.setBackground(Color.blue);
    textArea.setForeground(Color.WHITE);
    textArea.setText(instructions + systemPrompt);
    back = instructions + systemPrompt;
    textArea.setCaretColor(Color.red);
    textArea.setCaretPosition(textArea.getDocument().getLength());

    JScrollPane scrollPane = new JScrollPane(textArea);
    add(scrollPane);
    setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    timer = new javax.swing.Timer(500, this);
    //timer.start();
    setFocus();
    Log.mes("DosSim parameterised constructor");
  }

  public static void setFocus() {
    textArea.grabFocus();
    timer.start();
  }
  
  public static void releaseControl(){
    Log.mes ("DosSim.releaseControl");
    cb = null;
    showPrompt(systemPrompt, null);
  }

  public static void setXML(String xml) {
    DosSim.xml = xml;
  }

  public static void clearWithSystemPrompt() {
    clear();
    DosSim.cb = null;
    showPrompt(systemPrompt, new DosSim());
  }

  /**
   * clear screen
   */
  public static void clear() {
    try {
      sb = new StringBuilder();
      back = "";
      textArea.setText("");
    } catch (Exception e) {
      Log.mes(e);
    }
  }

  public static void print(String prompt, CB cb, String xml) {
    Log.mes("DosSim.print cb: " + cb.getName() + ",  xml: <" + xml + ">");
    DosSim.cb = cb;
    //DosSim.xml = xml;
    print(prompt);
    CB cb1 = DosSim.cb;
    DosSim.cb = null;
    cb1.callBack(xml);

  }

  public static void print(String prompt) {
    //Log.mes("DosSim.print1 prompt: <" + prompt + ">");

    try {
      back += prompt;
      textArea.append(prompt);
      //back = textArea.getText();
      sb = new StringBuilder();
      int newLength = textArea.getDocument().getLength();
      textArea.setCaretPosition(newLength);
      //Log.mes("DosSim.p2a newLength: " + newLength);

    } catch (Exception e) {
      Log.mes(e);
    }
  }

  public static void wfek(CB cb, String xml) {
    // Log.mes("DosSim.wfek xml: " + xml);

    DosSim.wfekxml = xml;
    DosSim.wfekcb = cb;
    CB cb1 = (CB) (new DosSim());
    ShowPrompt("\nPress Enter key to continue . . .", cb1, null);
  }

  public static void wfek1() {
    CB cb1 = wfekcb;
    String xml1 = wfekxml;
    wfekcb = null;
    wfekxml = null;
    if (cb1 != null) {
      cb1.callBack(xml1);
    }
  }

  public static void ShowPrompt(String prompt, CB cb1, String xml) {
    if (xml != null) {
      DosSim.xml = xml;
    }
    // Log.mes("DosSim.showPrompt1 cb: " + cb1.getName() + ", xml:  " + xml + ",  prompt: <" + prompt + ">");
    showPrompt(prompt, cb1);
  }

  public static void showPrompt(String prompt, CB cb) {
    //Log.mes("DosSim.showPrompt2 cb: " + cb.getName() + ",  prompt: <" + prompt + ">");

    DosSim.cb = cb;
    DosSim.print(prompt);
  }

  public void actionPerformed(ActionEvent ae) {
    update();
  }

  public void update() {
    String s = textArea.getText();
    //Log.mes("DosSim.update1 textarea.length: " + s.length() + ", back.length():" + back.length());
    //Log.mes("DosSim.update2 textarea: " + s);
    //Log.mes("DosSim.update3 back: " + back);
    if (s.length() < back.length()) {  // protect the prompt
      writeBackToTextArea();
    } else {
      if (s.length() > back.length()) {
        String response1 = s.substring(back.length());
        //Log.mes("DosSim response1 = " + response1);
        if (response1.charAt(response1.length() - 1) == '\n') {
          String response = response1.substring(0, response1.length() - 1);
          Log.mes("DosSim.update4 response: <" + response + ">");
          back = s;
          if (cb == null) {
            Log.mes("DosSim.update5 cb == null");
            callBack(response);
          } else {
            cb.callBack(response);
          }
        }
      }
    }
    textArea.setCaretPosition(textArea.getDocument().getLength());
  }

  private static void writeBackToTextArea() {
    Log.mes("DosSim.writeBackToTextArea");
    textArea.setText(back);
    textArea.setCaretPosition(textArea.getDocument().getLength());
  }

  static private String response;

  private String help = "\n"
          + "?            - display this help\n"
          + "load         - load game\n"
          + "run          - run game\n"
          + "test row col - run player\n"
          + "clear        - clear screen\n";

  public void callBack(String response) {
    //Log.mes("DosSim.callBack response: " + response);

    if (wfekcb != null) {
      wfek1();
    } else if (response.equals("?")) {
      showPrompt(help + systemPrompt, new DosSim());
    } else if (response.length() == 0) {
      print(systemPrompt);
    } else if (response.equals("load")) {
      loadGame();
    } else if (response.equals("run")) {
      runGame();
    } else if (response.equals("clear")) {
      clearWithSystemPrompt();
    } else if (response.startsWith("test")) {
      runTest(response);
    } else {
      showPrompt("I do not understand <" + response + ">\n" + systemPrompt, new DosSim());
    }
  }

  private void loadGame() {
    Log.mes("DosSim.loadGame");
    SceneManager.gameLoaded = RD.readData();
      if (SceneManager.gameLoaded) {
        SM_Map.smmap.populate();
        Log.mes("***Game data read done!");
        print("***Game data read done!\n");
      } else {
        Log.mes("***Game data read went wrong!");
        print("***Game data read went wrong!\n");
      }
    print(systemPrompt);
  }

  private void runGame() {
    Log.mes("DosSim.runGame");
    if (SceneManager.gameLoaded) {
      DD1.phase1();
    } else {
      print("Please load game first");
    }
  }
  
  
  private void runTest(String response){
    Log.mes("DosSim.runTest");
    int row = 2; // set normal start
    int col = 2; 
    String res[] = RD.mysplit(response);
    if(res.length == 3){
      try{
        row = Integer.parseInt(res[1]);  Log.mes("test row: " + row);
        col = Integer.parseInt(res[2]);   Log.mes ("test col: " + col);
      } catch(Exception ex){}
    }
    if (! SceneManager.gameLoaded) 
       loadGame();
    Player player = Player.getPlayer();
    player.setRow(row);
    player.setCol(col);
    player.setName("Ed");
    player.es2();

    }    
    
  }

