package ge;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.*;

/**
 *
 * @author eddie
 */
public class IO {

    Scanner fr;
    int ln;
    boolean ok = false;

    public IO() {
        if (!loadFile("../src/ge/game.txt")) {
            loadFile("src/ge/game.txt");
        }
    }

    public IO(File file) {
        loadFile1(file);
    }

    public boolean loadFile(String fileName) {
        boolean ok = false;
        try {
            File file = new File(fileName);
            ok = loadFile1(file);
        } catch (Exception e) {
            Log.mes(e);
        }
        return ok;
    }

    public boolean loadFile1(File file) {
        try {
            fr = new Scanner(file);
            ok = true;
        } catch (Exception e) {
            System.out.println(e.toString());
        }
        return ok;
    }

    public String nextLine() {
        ln++;                        // increment line number
        String s = "";             // s to contain next line
        if (hasNextLine()) {
            s = fr.nextLine();
        }
        s = s.strip();              // remove any leading or trailing spaces
        if (s == null) // just in case
        {
            s = "";
        }
        return s;
    }

    public boolean hasNextLine() {
        return fr.hasNextLine();
    }

    public int getLineNumber() {
        return ln;
    }

    public void close() {
        fr.close();
    }

    public static void printDesc(ArrayList<String> desc) {
        for (String s : desc) {
            if (!s.startsWith("<")) {
                System.out.println(s);
            }
        }
    }

    public static int inputIntFromPlayer(String prompt) {
        int answer = -1;
        String strInt = inputStringFromPlayer(prompt);
        try {
            answer = Integer.parseInt(strInt);
        } catch (Exception e) {
            System.out.println("Conversion to int problem: " + e.toString());
            answer = inputIntFromPlayer(prompt); // recursive calls till player gets it rightz

        }
        return answer;
    }

    public static String inputStringFromPlayer(String prompt) {
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader reader = new BufferedReader(isr);
        String answer = "";
        try {
            System.out.print(prompt);
            while (answer.length() == 0) {
                answer = reader.readLine();
            }
        } catch (Exception e) {
            System.out.println("input problem: " + e.toString());
            System.exit(0);
        }
        try {
            isr.close();
            reader.close();
        } catch (Exception e) {
            System.out.println("reader.close " + e);
        }
        return answer;
    }

    // Sleep method to provide a slower text scroll at the beginning of the game
    private static void sleepScroller(int pauseTime) {
        try {
            Thread.sleep(pauseTime);
        } catch (InterruptedException ieEx) {
            ieEx.printStackTrace();
        }
    }

}
