package ge;

import java.util.*;

/**
 * Item.java - object class for the creation of Inventory Item objects to
 * populate the backpack in the text adventure game Dastardly Dungeons of Doom -
 *
 * @author Luke Eberbach 2024
 */
public class Item {
    public static Map<String, Item> items = new HashMap<>();

    private HashMap<String, String> data;

    public Item(String xml){
        data = RD.getDataMap(xml) ;
        String key = RD.getValue(data, "key");
       // Log.mes("Item.getItem key: " + key);
        items.put(key, this);
        
    }
  
    // Getter methods to obtain the value of instance variables
    public String getName() {
        return data.get("name");
    }

    public String getKey() {
        return data.get("key");
    }

    public String getType() {
        return data.get("type");
    }

    public int getWeight() {
         return RD.getIntValue(data, "weight");
    }

    public int getDamageFactor() {
        return RD.getIntValue(data, "damageFactor");
    }

    public int getStrenthAdd() {
        return RD.getIntValue(data, "strengthadd");
    }

    public static Item readItem(IO fr, String xml) {
        Item item = new Item(xml);
        return item;
    }

    /**
     * toString() method to return detailed information about individual instances of the Item class
     */
    @Override
    public String toString() {
        String itemDetails = "Item " + getKey() + ", " + getName() + " is a " + getType()
                + ". It has a weight of " + getWeight() + " and a Damage Factor of " + getDamageFactor() + ".";
        return itemDetails;
    }
}
