package ge;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;
import java.sql.*;

/**
   log events as they happen to a file for later analysis.
 */
public class Log {
  /** debug */
  static boolean debug = true;

  /** zz */
  static String zz = "Log.";
  /** raf */
  private static RandomAccessFile raf = null;
  /** dom */
  private static int dom = 0;
  /** olddom */
  private static int olddom = 0;
  /** dummy default constructor */
  public Log(){}
  /**
   exception mes
   @param e - exception to log
   */
  public static synchronized void mes (Exception e) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      mes (sw.toString());

  }
  
  /**
   log string message
   @param title - 
   */
  public static synchronized void mes (String title) {
      char cr = '\r';
      char lf = '\n';

      if ((title.indexOf ("***") > -1) || debug) {
        if (raf == null)
           openLogFile ();
        try
        {
          if (title != null) {
            if (testTitleRep(title)){     
              title =  getCurrentDateTime() + " " + title;
              raf.seek (raf.length ());
              raf.writeBytes (title + cr + lf);
            }
          }
        }
        catch (IOException e) {
           System.out.println (getCurrentDateTime() + " Log.mes IOError: " + e.toString());
        }
      }
   }
/**
 * last Mes
 */
   static String lastMes = "";
   /**
    * repetition count
    */
   static int repCount = 0;
   /**
    * test Title Repetition
    * @param title -
    * @return true if to be printed
    */
   static boolean testTitleRep(String title){
       boolean answer = true;

       return answer;
   }
   /**
    mesNoTime
    @param title -
    */
   public static synchronized void mesNoTime (String title) {
      char cr = '\r';
      char lf = '\n';
      if (raf == null)
         openLogFile ();
      try
      {
         raf.seek (raf.length ());
         raf.writeBytes (title + cr + lf);
      }
      catch (IOException e) {
         System.out.println (getCurrentDateTime() + " Log.mes IOError: " + e.toString());
      }
   }

   /**
    str
    @param title -
    @param message -
    */
   static void str (String title, String message) {
      mes (title + ": " + message);
   }

   /**
    access
    @param a -
    @param m -
    */
   static void access (boolean [] a, String m){
     mes (m + "  access length = " + a.length);
     for (int i = 0; i < a.length; i++)
        mes (m + "  access [" + i + "] = " + a[i]);
   }

   /**
    messageBox todo
    @param text -
    @param title -
    @param flags -
    */
   static void messageBox (String text, String title, int flags) {
       System.out.println (getCurrentDateTime() + " " + title + ": " + text);
       wfk ();
   }

   /**
    i
    @param title -
    @param i -
    */
   static void i (String title, int i) {
      mes (title + ": " + i);
   }

   
   /**
    ba
    @param title -
    @param b -
    */
   static void ba (String title, byte [] b) {
      String sb = new String ("");
      String hb = new String ("");
      hb = "";
      mes (title + '\r' + '\n' );
      int i,l;
      l = b.length;
      int j = 0;
      for (i = 0; i < l; i++){
         if (((i % 16) == 0) && (i > 0)) {
            mesNoTime (new String (hb));
            hb = "\r" + '\n' + Integer.toHexString(i);
         }
         hb = hb + " ";
         j = ((int) b [i]) & 0xFF;
         if (j < 16) hb = hb +  ('0');
         hb = hb + Integer.toHexString (j);
      }
      if ((i % 16) != 0)
         mesNoTime (hb);
   }


   /**
    ba
    @param title -
    @param b -
    @param l -
    */
   static void ba (String title, byte [] b, int l) {
      String sb = new String ("");
      String hb = new String ("");
      hb = "";
      mes (title + '\r' + '\n' );
      int i;
      int j = 0;
      for (i = 0; i < l; i++){
         if (((i % 16) == 0) && (i > 0)) {
            mesNoTime (new String (hb));
            hb = "\r" + '\n' + Integer.toHexString(i);
         }
         hb = hb + " ";
         j = ((int) b [i]) & 0xFF;
         if (j < 16) hb = hb +  ('0');
         hb = hb + Integer.toHexString (j);
      }
      if ((i % 16) != 0)
         mesNoTime (hb);
   }


  /**
   map
   @param z - 
   @param m -
   */
   static void map (String z, Map<String, String> m) {
       mes(z);
     if (m != null) {
       for (Map.Entry<String,String> entry : m.entrySet()) {
           mes(entry.getKey() + ": " + entry.getValue());

       }
     }
   }

 /**
   map
   @param z - 
   @param m -
   */
   public static void mapNPC (String z, Map<String, NPC> npc) {
       mes(z);
     if (npc != null) {
       for (Map.Entry<String,NPC> entry : npc.entrySet()) {
           mes("<" +entry.getKey() + ">: <" + entry.getValue() + ">");

       }
     }
   }



  /**
   wrapup
   */
   static void wrapUp () {
      try {
         if (raf != null)
            raf.close();
         raf = null;
      }
      catch (IOException e) {
         System.out.println (getCurrentDateTime() + " Log.wrapup IOError: " + e.toString());
      }
   }

   
   /** 
    open log file
    */
   private static void openLogFile () {
      int fileSize;
      try {
         raf = new RandomAccessFile (getLogFileName (), "rw");
         try {
            fileSize = (int) raf.length();
         }
         catch (IOException e) {
            System.out.println (getCurrentDateTime() + " Log.OpenLogFile IOError: " + e.toString());
         }
      }
      catch (Exception e) {
         System.out.println (getCurrentDateTime() + " Log.OpenLogFile Error: " + e.toString());
      }
   }

  /**
   get log file name
   @return string of name
   */
   static String getLogFileName () {
     return "e" + getCurrentDay () + ".log";

   }

  /**
   mem
   @param s -
   */
   static void mem (String s){
      Runtime rt = Runtime.getRuntime();
      long fm = 0L;
      long tm = 0L;
      fm = rt.freeMemory() / 1000;
      tm = rt.totalMemory() / 1000;
      String sfm = Long.toString (fm);
      String stm = Long.toString (tm);
      mes (s + " " + sfm + "/" + stm);
   }

   /** 
    get character from keyboard
    @return character
    */
   static int getChar () {
      int c = 0;

      try {
         c = System.in.read();
      }
      catch (Exception e) {
         System.out.println (getCurrentDateTime() + " Error: " + e.toString());
      }
      return (c);
   }


   /**
    wfk
    */
   static void wfk () {
      int c = 0;
      System.out.print (getCurrentDateTime() + " Press Return to continue: ");
      while ((c = getChar ()) != 13) {
//         switch (c) {
//            case 'l': Toks.listAll (); break;
//
//         }
      }
   }
   
   /**
    get current time
    @return time string
    */
   static String getCurrentTime () {

      GregorianCalendar gc = new GregorianCalendar ();
      int h = gc.get(Calendar.HOUR);
      int m = gc.get(Calendar.MINUTE);
      int s = gc.get(Calendar.SECOND);
      int ms = gc.get(Calendar.MILLISECOND);
      String currentTime =   h + "-" + m + "-" + s + ":" +ms ;
      return currentTime;
  }




   /**
    get current day
    @return time string
    */
   static String getCurrentDay () {
      GregorianCalendar gc = new GregorianCalendar ();
      int dm = gc.get (Calendar.DAY_OF_MONTH);
      String currentDay =   String.valueOf(dm);
      return currentDay;
  }

   /**
    get current date and time
    @return time string
    */
  static String getCurrentDateTime()
  {
      SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyy HH:mm:ss-S ");
      GregorianCalendar gc = new GregorianCalendar ();
      olddom = dom;
      dom = gc.get (Calendar.DAY_OF_MONTH);
      if (dom != olddom) {
        if (raf != null) {
          wrapUp ();
          try {
            File f = new File (getLogFileName ());
            if (f.exists())
              f.delete ();
          } catch (Exception ioe) {
            System.out.println (ioe.toString ());
          }
          openLogFile ();
        }
      }
    return sdf.format (gc.getTime());
  }
  /**
   get time
   @return time as Date
   */
  static long getTime()
  {
    java.util.Date d = new java.util.Date();
    long Time = d.getTime();
    return Time;
  }

   /**
    get current date
    @return time string
    */
  static String getCurrentDate () {
      GregorianCalendar gc = new GregorianCalendar ();
      int yr = gc.get (Calendar.YEAR);
      int mo = gc.get (Calendar.MONTH) + 1;
      int dm = gc.get (Calendar.DAY_OF_MONTH);
      String m = null;
      switch(mo){
          case 1: m = "Jan"; break;
          case 2: m = "Feb"; break;
          case 3: m = "Mar"; break;
          case 4: m = "Apr"; break;
          case 5: m = "May"; break;

          case 6: m = "Jun"; break;
          case 7: m = "Jul"; break;
          case 8: m = "Aug"; break;
          case 9: m = "Sep"; break;
          case 10: m = "Oct"; break;
          case 11: m = "Nov"; break;
          case 12: m = "Dec"; break;
    }

      String date = dm + "-" + m + "-" + yr;
      return date;
  }

  
  /** 
   get date time no seconds
   @return time string
   */
  static String getDateTimeNoSecond()
  {
    GregorianCalendar gc = new GregorianCalendar ();
    int h = gc.get(Calendar.HOUR);
    if(h == 0)
       h = 12;
    int m = gc.get(Calendar.MINUTE);

      String currentTime =   h + ":" + m ;
    String currentDateTimeNoSecond = getCurrentDate() + " " + currentTime;
    return currentDateTimeNoSecond;
  }



  /**
   delete the next 10 files in the monthly cycle.
   */
  static void deleteNextTenLogFiles () {
    String z = zz + "deleteNextTenLogFiles ";
    GregorianCalendar gc = new GregorianCalendar ();
    try {

//      File file = new File (".");
//      mes (z + "asking for file list");
//      String [] flist = file.list ();
//      if (flist.length > 0)
//        for (int i = 0; i < flist.length; i++)
//          if (flist [i].endsWith (".txt"))
//            mes (z + i + ": " + flist [i]);
//


    } catch (Exception e) {
      mes (z + e.toString ());
    }
  }




}  //