package ge;

import java.util.*;

/**
 * Character.java - object class for the creation of player and NPC characters
 * for the text adventure game Dastardly Dungeons of Doom -
 *
 * @author Luke Eberbach 2024
 */
public class NPC {

    public HashMap<String, String> data;
    public static HashMap<String, NPC> npcs = new HashMap<>();
    Desc desc;
    Desc alive;
    Desc dead;

    Choice choice;

    /**
     * main Constructor for the Character class
     *
     * @param xml -
     */
    public NPC(String xml) {
        data = RD.getDataMap(xml);

        try {

            int hpmax = RD.getIntValue(data, "hpmax");
            int hp = ((int) (Math.random() * hpmax) + 1);
            RD.putIntDataValue(data, "hp", hp);

            int strengthmax = RD.getIntValue(data, "strengthmax");
            int strength = ((int) (Math.random() * strengthmax) + 1);
            RD.putIntDataValue(data, "strength", strength);
        } catch (Exception e) {
            Log.mes(e);
        }
    }

    // Setter methods for the character class
    public void setName(String name) {
        try {
            RD.putDataValue(data, "name", name);
        } catch (Exception e) {
            Log.mes(e);
        }
    }

    // Setter methods for the character class
    public void setDesc(Desc desc) {
        this.desc = desc;
    }

    public void setType(String type) {
        try {
            RD.putDataValue(data, "type", type);
        } catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setHp(int hp) {
        try {
            RD.putIntDataValue(data, "hp", hp);
        } catch (Exception e) {
            Log.mes(e);
        }

    }

    public void setStrength(int strength) {
        try {
            RD.putIntDataValue(data, "strength", strength);
        } catch (Exception e) {
            Log.mes(e);
        }
    }

    public void setPoints(int points) {
        try {
            RD.putIntDataValue(data, "points", points);
        } catch (Exception e) {
            Log.mes(e);
        }

    }
    
    public static NPC getNPC(String key){
        Log.mapNPC("NPC.getNPC key: ", npcs);
        return npcs.get(key);
    }

    // Getter methods for the character class
    public String getName() {
        String name = null;
        try {
            name = data.get("name");
        } catch (Exception e) {
            Log.mes(e);
        }
        return name;
    }

    public String getKey() {
        String key = null;
        try {
            key = data.get("key");
        } catch (Exception e) {
            Log.mes(e);
        }
        return key;
    }

    public String getType() {
        String type = null;
        try {
            type = data.get("type");
        } catch (Exception e) {
            Log.mes(e);
        }
        return type;
    }

    public Desc getDesc() {
        return desc;
    }

    public int getHp() {
        int hp = -1;
        try {
            hp = RD.getIntValue(data, "hp");
        } catch (Exception e) {
            Log.mes(e);
        }
        return hp;
    }

    public int getStrength() {
        int strength = -1;
        try {
            strength = RD.getIntValue(data, "strength");
        } catch (Exception e) {
            Log.mes(e);
        }
        return strength;
    }

    /**
     *
     * @return points
     */
    public int getPoints() {
        return RD.getIntValue(data, "points");
    }

    public static void readNPC(IO fr, String xml) {
        Desc desc = null, alive = null, dead = null;
        String key = null;
        Choice choice = null;

        NPC npc = new NPC(xml);
        key = npc.data.get("key");
        npcs.put(key, npc);
        boolean done = false;
        while (!done) {
            String s = fr.nextLine();
            if (RD.debug) {
                System.out.println("npc line:" + s);// diagnostic
            }
            if (s.startsWith("</npc")) {
                //if(RD.d){
                //System.out.println("\nprint npc\n");// diagnostic
                //for(NPC npc1 : NPC.npcs)
                //   System.out.println(" - npc: " + npc1.getKey());
                //  System.out.println(npc);
                //}
                done = true;
            } else if (s.startsWith("<alive")) {
                alive = Desc.readDesc(fr);
            } else if (s.startsWith("<dead")) {
                dead = Desc.readDesc(fr);
            } else if (s.startsWith("<desc")) {
                desc = Desc.readDesc(fr);
            } else if (s.startsWith("<choice")) {
                choice = Choice.readChoice(fr, s);
            }
        }
    }

    /**
     * toString() method for the npc class
     *
     * @return Character description
     */
    @Override
    public String toString() {
        StringBuilder charDetails = new StringBuilder();
        charDetails.append("The " + getKey() + " " + getName());
        charDetails.append(" is a " + getType() + ", ");
        charDetails.append("has " + getHp() + " hit points,");
        charDetails.append(" and " + getStrength() + " strength points.\n");
        Desc desc = getDesc();
        if (desc != null) {
            charDetails.append(desc.toString());
        }
        return charDetails.toString();
    }
}
