package ge;

/**
 *
 * @author eddie
 */
public class Option {

    String answer, prompt;
    Win win;
    Loss loss;

    public Option(String answer2, String prompt2, Win win2, Loss loss2) {
        this.answer = answer2;
        this.prompt = prompt2;
        this.win = win2;
        this.loss = loss2;
    }

    public static Option readOption(IO fr, String s) {
        Option option1 = null;
        String answer1 = RD.getLHS(s);
        String prompt1 = RD.getRHS(s);
        Win win1 = null;
        Loss loss1 = null;

        boolean done = false;
        while (!done) {
            s = fr.nextLine();
            if (RD.debug) {
                System.out.println("option line:" + s);// diagnostic
            }
            if (s.startsWith("</" + answer1)) {
                option1 = new Option(answer1, prompt1, win1, loss1);
                if (RD.d) {
                    System.out.println("\nprint option");// diagnostic
                    System.out.println(option1);
                }
                done = true;
            } else if (s.startsWith("<win")) {
                win1 = Win.readData(fr, s);
            } else if (s.startsWith("<loss")) {
                loss1 = Loss.readData(fr, s);
            } else {
                RD.report("Option", fr, s);
            }

        }
        return option1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nOption answer: ");
        sb.append(this.answer);
        sb.append(", Option prompt: ");
        sb.append(this.prompt);
        return sb.toString();
    }
}

class Win {

    Desc desc = null;
    int odds = -1;
    int points2Add = 0;

    public Win(Desc desc, int odds, int points2Add) {
        // Win win = null;
        this.desc = desc;
        this.odds = odds;
        this.points2Add = points2Add;
    }

    public static Win readData(IO fr, String s) {
        Win win = null;
        Desc desc = null;
        int points2Add = 0;
        int odds = RD.getRHSint(s);
        boolean done = false;
        while (!done) {
            s = fr.nextLine();
            if (RD.debug) {
                System.out.println("Win line:" + s);// diagnostic
            }
            if (s.startsWith("</win")) {
                win = new Win(desc, odds, points2Add);
                if (RD.d) {
                    System.out.println("\nwin\n");
                    System.out.println(win);
                }
                done = true;
            } else if (s.startsWith("<desc")) {
                desc = Desc.readDesc(fr);
            } else if (s.startsWith("<addpoints")) {
                points2Add = RD.getRHSint(s);
            } else {
                RD.report("Win", fr, s);
            }
        }
        return win;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("odds: ");
        sb.append(odds);
        return sb.toString();
    }
}// end Win class

class Loss {

    int odds = -1;
    Desc desc;
    int points2Add = 0;

    public Loss(Desc desc, int odds, int points2Add) {

        this.desc = desc;
        this.odds = odds;
        this.points2Add = points2Add;
    }

    public static Loss readData(IO fr, String s) {
        Desc desc = null;
        Loss loss = null;
        int points2Add = 0;
        int odds = RD.getRHSint(s);
        boolean done = false;
        while (!done) {
            s = fr.nextLine();
            if (RD.debug) {
                System.out.println("Loss line:" + s);// diagnostic
            }
            if (s.startsWith("</loss")) {
                loss = new Loss(desc, odds, points2Add);
                if (RD.d) {
                    System.out.println("\nloss\n");
                    System.out.println(loss);
                }
                done = true;
            } else if (s.startsWith("<desc")) {
                desc = Desc.readDesc(fr);
            } else if (s.startsWith("<addpoints")) {
                points2Add = RD.getRHSint(s);
            } else {
                RD.report("Loss", fr, s);
            }
        }
        return loss;
    }// end readData method

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("odds: ");
        sb.append(odds);
        return sb.toString();
    }
}// end Loss class
