package ge;

import static ge.Scene.map;
import java.util.*;

/**
 *
 * @author e55023
 */
public class Player implements CB {

  String zz = "Player.";

  public static ArrayList<Player> players = new ArrayList<>();
  //instance variables 
  public HashMap<String, String> data;
  static Desc init;
  boolean initFlag = true;
  /**
   * health points
   */
  ArrayList<String> inventory = new ArrayList<>();

  public Player(String xml) {
    data = RD.getDataMap(xml);
    Log.mes("new Player class" + xml);
    players.add(this);

    setRandomHp();
    //Log.mes("Player hp: " + getHp());

    setRandomStrength();
    // Log.mes("Player strength: " + getStrength());



  }

  public int getCol() {
    return RD.getIntValue(data, "col");
  }
 public HashMap<String, String> getData(){
   Log.mes ("Player.getData " + RD.getXML("Player", data));
    return data;
  }

  public String getGame(){
    return RD.game;
  }
 
  public int getHp() {
    return RD.getIntValue(data, "hp");
  }

  public int getHpMax() {
    return RD.getIntValue(data, "hpmax");
  }

  public String getInit(){
    Log.mes("Player.getInit " + init.toString());
    return init.toString();
  }
 
  public String getName() {
    return RD.getValue(data, "name");
  }

  public int getRow() {
    return RD.getIntValue(data, "row");
  }

  public int getStatus(){
       return RD.getIntValue(data, "status");
  }
  
  
  public int getStrength() {
    return RD.getIntValue(data, "strength");
  }

  public int getStrengthMax() {
    return RD.getIntValue(data, "strengthmax");
  }

  public ArrayList<String> getInventory(){
    return inventory;
  }
 
  public void addItem(String  item){
    inventory.add(item);
    
  }
  public int getPoints() {
    return RD.getIntValue(data, "points");
  }

  public static Player getPlayer() {
    Player player = null;
    if (!players.isEmpty()) {
      player = players.get(0);
    }
    return player;
  }
  
  public void setStatus(int status){
        RD.putIntDataValue(data, "status", status);

  }

  public void setName(String name) {
    RD.putDataValue(data, "name", name);
  }

  public void setStrength(int strength) {
    RD.putIntDataValue(data, "strength", strength);

  }

  public void setRandomStrength() {
    int strengthmax = getStrengthMax();
    int strength = ((int) (Math.random() * strengthmax) + 1);
    setStrength(strength);
  }

  public void setHp(int hp) {
    RD.putIntDataValue(data, "hp", hp);

  }

  public void setRandomHp() {
    int hpMax = getHpMax();
    int hp = ((int) (Math.random() * hpMax) + 1);
    setHp(hp);
  }

  public void setPoints(int points) {
    RD.putIntDataValue(data, "points", points);
  }

  public void setRow(int row) {
    RD.putIntDataValue(data, "row", row);
  }

  public void setCol(int col) {
    RD.putIntDataValue(data, "col", col);
  }

  /**
   *
   * @param player
   */
  public static void setPlayer(Player player) {
    players.add(player);
  }

  public void startPlayer(Player player) {
    Log.map("Player.enterScene ", data);
    if (init != null && initFlag) {
      init.print(this, "<next=1>");
      initFlag = false;
    } else {
      es1();
    }
  }

  private void es1() {
      DosSim.wfek( this, "<wait=es2>");
}
  public void es2(){  // test starts here
      int row = getRow();
      int col = getCol();
      Scene.map[row][col].enterScene(getPlayer(), data);
  }

  public void callBack(String xml) {
    Log.mes("Player.callBack xml: " + xml);
    String p1 = RD.getLHS( xml);
    switch (p1) {
      case "next":
        es1();
        break;
      case "wait":
        es2();
        break;
      case "move":
        move(xml);
        break;
     case "move2":
        move2(xml);
        break;
      default: Log.mes("Player.callBack default p1: " + p1);
      move2(xml);
      break;
    }
  }



  public boolean checkForItem(Item item) {
    return inventory.contains(item.getKey());
  }

  public void move(String xml) {
    Log.mes("Player.move xml: " + xml);

    if (getPoints() > -1) {   // 0 or above
      DosSim.print("Points: " + getPoints() + "/100 - ");
      DosSim.print("  Your inventory: " + inventory);
      DosSim.setXML("<move2=>");
      int row = getRow();// get player position
      int col = getCol();
      Scene scene = map[row][col];
      if (scene.getItem() == null)
         DosSim.showPrompt("\nEnter move direction (n,e,s,w)  or q[uit]): ", this);
       else
        DosSim.showPrompt("\nEnter move direction (n,e,s,w), t(ake), or q[uit]): ", this);
    }
  }
  
  private void takeItem(){
      int row = getRow();// get player position
      int col = getCol();
      Scene scene = map[row][col];
      Item item = scene.getItem();
      if (item != null){
         scene.removeItem(item);
      }
  }

  public void move2(String input) {
    Log.mes ("Player.move2: " + input);
    switch (input) {
      case "n":
        goNorth();
        break;
      case "e":
        goEast();
        break;
      case "s":
        goSouth();
        break;
      case "w":
        goWest();
        break;
      case "q":
        setStatus ( 7); // quit
        break;
      case "t":
        takeItem();
        break;
      default:
        DosSim.print("Bad Direction: " + input + "  Do please try again!");
    }
    int status = getStatus();
    if(status == 0)
       es2();
    else {
            Log.mes("Player.move2 status: " + status);
      if(status == 7){
      DosSim.print("Please come back another time!\n");
      } else {
      DosSim.print("You have been killed!\n");        
      }
      DosSim.print("Game Over!\n");  
      DosSim.releaseControl();
    }
    
  }


  private void goNorth() {
        int newRow = getRow();
        newRow--;
        if (newRow < 0) {
            setStatus (1);// show out of bounds
        } else {
            setRow(newRow);
        }
    }

    private void goEast() {
        int newCol = getCol();
        newCol++;
        if (RD.cols > newCol) {
             setCol(newCol);
        } else {
            setStatus(1);// show out of bounds
        }
    }

    private void goSouth() {
        int newRow = getRow();
        newRow++;
        if (RD.rows > newRow) {
            setRow(newRow);
        } else {
            setStatus(1);// show out of bounds
        }
    }

    private void goWest() {
        int newCol = getCol();
        newCol--;
        if (newCol < 0) {
            setStatus(1);// show out of bounds
        } else {
            setCol(newCol);
        }
    }

    void printMap() {
        for (int row = 0; row < RD.rows; row++) {
            System.out.println("\n"); // leave a blank line
            for (int col = 0; col < RD.cols; col++) {
                System.out.print("\t" + map[row][col].getName());
            }
        }
    }

    void printMiniMap(int x, int y) {
        System.out.println();
        printRow1(x, y);
        printRow2(x, y);
        printRow3(x, y);
    }

    void printRow1(int x, int y) {
        printSection("   ", x - 1, y - 1, 1);
        printSection("1: ", x, y - 1, 1);
        printSection("   ", x + 1, y - 1, 1);
        System.out.println();
        printSection("   ", x - 1, y - 1, 2);
        printSection("   ", x, y - 1, 2);
        printSection("   ", x + 1, y - 1, 2);
        System.out.println();
        printSection("   ", x - 1, y - 1, 3);
        printSection("   ", x, y - 1, 3);
        printSection("   ", x + 1, y - 1, 3);
        System.out.println("\n");
    }

    void printRow2(int x, int y) {
        printSection("4: ", x - 1, y, 1);
        printSection(" * ", x, y, 1);
        printSection("2: ", x + 1, y, 1);
        System.out.println();
        printSection("   ", x - 1, y, 2);
        printSection(" * ", x, y, 2);
        printSection("   ", x + 1, y, 2);
        System.out.println();
        printSection("   ", x - 1, y, 3);
        printSection(" * ", x, y, 3);
        printSection("   ", x + 1, y, 3);
        System.out.println("\n");
    }

    void printRow3(int x, int y) {
        printSection("   ", x - 1, y + 1, 1);
        printSection("3: ", x, y + 1, 1);
        printSection("   ", x + 1, y + 1, 1);
        System.out.println();
        printSection("   ", x - 1, y + 1, 2);
        printSection("   ", x, y + 1, 2);
        printSection("   ", x + 1, y + 1, 2);
        System.out.println();
        printSection("   ", x - 1, y + 1, 3);
        printSection("   ", x, y + 1, 3);
        printSection("   ", x + 1, y + 1, 3);
        System.out.println("\n");
    }

    void printSection(String prefix, int c, int r, int ln) {
        String s = null;
        if (r >= 0 && RD.rows > r
                && c >= 0 && RD.cols > c) {
            s = printInsideArea(prefix, r, c, ln);
        } else {
            s = printOutsideArea(prefix, r, c, ln);
        }
        printFixedWidth(s, 20);
    }// end printSection

    String printInsideArea(String prefix, int r, int c, int ln) {
        String s = null;
        switch (ln) {
            case 1:
                s = prefix + Scene.map[r][c].getName();
                break;
            case 2:
                Item item = Scene.map[r][c].getItem();
                if (item == null) {
                    s = "                  ";
                } else {
                    s = prefix + "(" + item.getName() + ")";
                }
                break;
            case 3:
                Item need = Scene.map[r][c].getNeed();
                if (need == null) {
                    s = " ";
                } else {
                    s = prefix + "Need: " + need.getName();
                }
                break;
        }
        return s;
    }

    String printOutsideArea(String prefix, int r, int c, int ln) {
        String s = null;
        switch (ln) {
            case 1:
                s = prefix + "Death Zone     ";
                break;
            case 2:
                s = " ";
                break;
            case 3:
                s = " ";
                break;
        }
        return s;
    }

    public void printFixedWidth(String s, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(s);
        while (sb.length() < width) {
            sb.append(' ');
        }
        System.out.print(sb.toString());
    }

    public static Desc readInit(IO io) {
        Desc init = null;
        boolean done = false;
        while (!done) {
            String s = io.nextLine();
            if (RD.debug) {
                System.out.println("Player line:" + s);// diagnostic
            }
            if (s.startsWith("<desc")) {
                init = Desc.readDesc(io);
            } else if (s.startsWith("</init")) {
                done = true;
            }
        }
        return init;
    }

    
      public static void dumpMap() {
          System.out.print("\ndumpMap");
        for (int row = 0; row < RD.rows; row++) {
            System.out.print("row: " + row + " ");
            for (int col = 0; col < RD.cols; col++) {
                if (map[row][col] != null) {
                    System.out.print(" " + map[row][col].getName());
                } else {
                    System.out.print("   is null");
                }
            }
            System.out.println();
        }

    }

    public static void readPlayer(IO io, String s) {
        Player player = new Player(s);
        Desc init = null;
        boolean done = false;
        while (!done) {
            s = io.nextLine();
            if (RD.debug) {
                System.out.println("Player line:" + s);// diagnostic
            }
            if (s.startsWith("</player")) {
                done = true;
            } else if (s.startsWith("<init")) {
                Player.init = readInit(io);
            } else {
                RD.report("Reading Player data  ", io, s);
            }
        }

    }

    @Override
public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Player: ");
        sb.append("points: ");
        sb.append(getPoints());
        sb.append(", hp:");
        sb.append(getHp());
        sb.append(", strength: ");
        sb.append(getStrength());
        return sb.toString();
    }
}
