package ge;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author eddie
 */
public class SM_EditPlayer extends JPanel implements ActionListener {

  JTabbedPane tabs1;
  JTextArea desc;
  JTextField txtRow, txtCol, txtItem, txtInv, txtNPC, txtXML, txtButtonResponse, txtGame,
          txtMaxRows, txtMaxCols, txtName, txtWin;
  //JPanel pnlPos, pnlItem, pnlNeed, pnlNPC;
  JLabel lblRow, lblCol;
  JButton jbN, jbE, jbS, jbW, jbQ, jbLoad, jbSave;

  Scene scene;

  SM_EditPlayer(JTabbedPane tabs) {
    setLayout(new BorderLayout());
    fixNorthPanel();
    fixCenterPanel();
    fixSouthPanel();

    this.tabs1 = tabs;

  }

  //************************************//
  // Fix displayable widgets              //
  //************************************//
  private void fixNorthPanel() {

    JPanel jp = new JPanel();
    fixPositionDisplay(jp);
    txtGame = new JTextField(20);
    jp.add(txtGame);
    txtName = new JTextField("Player name goes here");
    Font f = txtName.getFont();
    Font f1 = new Font(f.getName(), Font.BOLD, 24);
    txtName.setFont(f1);
    jp.add(txtName);

    add(jp, BorderLayout.NORTH);
  }

  private void fixPositionDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblRow = new JLabel("Row:");
    txtRow = new JTextField(2);
    JLabel lblCol = new JLabel("Col:");
    txtCol = new JTextField(2);
    jp.add(lblRow);
    jp.add(txtRow);
    jp.add(lblCol);
    jp.add(txtCol);
    JLabel lblMaxRow = new JLabel("Max Row:");
    txtMaxRows = new JTextField(2);
    JLabel lblMaxCol = new JLabel("Max Col:");
    txtMaxCols = new JTextField(2);
    jp.add(lblMaxRow);
    jp.add(txtMaxRows);
    jp.add(lblMaxCol);
    jp.add(txtMaxCols);
    jp1.add(jp);
  }

  private void fixCenterPanel() {
    JPanel jp = new JPanel();
    jp.setLayout(new BorderLayout());
    fixInventoryDisplay(jp);

    desc = new JTextArea(6, 50);
    JScrollPane jsp = new JScrollPane(desc);
    Font f = desc.getFont();
    Font f1 = new Font(f.getName(), Font.PLAIN, 16);
    desc.setFont(f1);
    jp.add(jsp);

    fixXMLDisplay(jp);
    add(jp, BorderLayout.CENTER);

  }

  private void fixInventoryDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblInv = new JLabel("  Inventory:");
    txtInv = new JTextField(50);
    jp.add(lblInv);
    jp.add(txtInv);
    jp1.add(jp, BorderLayout.NORTH);

  }

  private void fixXMLDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblXML = new JLabel("  XML:");
    txtXML = new JTextField(60);
    jp.add(lblXML);
    jp.add(txtXML);
    jp1.add(jp, BorderLayout.SOUTH);
  }

  private void fixSouthPanel() {
    JPanel jp = new JPanel();
    txtButtonResponse = new JTextField(40);
    jp.add(txtButtonResponse);
    fixNavButtons(jp);

    add(jp, BorderLayout.SOUTH);
  }

  private void fixNavButtons(JPanel jp1) {
    JPanel jp = new JPanel();
    JButton jb = new JButton("some text");
    Font f = jb.getFont();
    Font f1 = new Font(f.getName(), Font.BOLD, 24);
    fixButton(jp, "Load", f1);
    fixButton(jp, "Save", f1);
    fixButton(jp, "N", f1);
    fixButton(jp, "E", f1);
    fixButton(jp, "S", f1);
    fixButton(jp, "W", f1);
    jp1.add(jp);
  }

  private void fixButton(JPanel jp, String text, Font f1) {
    JButton jb = new JButton(text);
    jb.setFont(f1);
    jb.addActionListener(this);
    jp.add(jb);
  }

//********************************//
// Load data into widgets         //
//********************************//
  public void actionPerformed(ActionEvent ae) {
    if (SceneManager.gameLoaded) {
      Object o = ae.getSource();
      if (o instanceof JButton) {
        JButton b = (JButton) o;
        String label = b.getText();
        Player player = Player.getPlayer();
        int row = player.getRow();
        int col = player.getCol();
        if (label.equals("N")) {
          if (row > 0) {
            row--;
            changeScene(row, col);
          }
        } else if (label.equals("E")) {
          if (col < (RD.cols - 1)) {
            col++;
            changeScene(row, col);
          }
        } else if (label.equals("S")) {
          if (row < (RD.rows - 1)) {
            row++;
          }
          changeScene(row, col);
        } else if (label.equals("W")) {
          if (col > 0) {
            col--;
            changeScene(row, col);
          }
        } else if (label.equals("Load")) {
          loadData();
        } else if (label.equals("Save")) {
          savePlayer();
        }
      }// end o instanceof JButton
    }// end xml.getText().length() != 0
    else {
      txtButtonResponse.setText("Please first load game");
    }
  }

  private void changeScene(int row, int col) {
    try {
      Player player = Player.getPlayer();
      player.setRow(row);
      player.setCol(col);
      loadPlayerData(player);
    } catch (Exception e) {
      Log.mes("SM_EditPlayer.changeScene " + e.toString());
    }
  }

  private void loadPlayerData(Player player) {
    try {
      HashMap<String, String> map = player.getData();
      String xml = RD.getXML("player", map);
      txtXML.setText(xml);
      fixInit();
      txtGame.setText(player.getGame());
      txtRow.setText(String.valueOf(player.getRow()));
      txtCol.setText(String.valueOf(player.getCol()));

      if (player.getName() != null) {
        txtName.setText(player.getName());
      }
      txtMaxRows.setText(String.valueOf(RD.rows));
      txtMaxCols.setText(String.valueOf(RD.cols));
      txtRow.setText(String.valueOf(player.getRow()));
      txtCol.setText(String.valueOf(player.getCol()));
    } catch (Exception e) {
      Log.mes("SM_EditPlayer.changeScene " + e.toString());
    }
  }

  private void fixInit() {
    Player player = Player.getPlayer();
    String desc1 = player.getInit();
    if (desc1 != null) {
      desc.setText(desc1);
    } else {
      desc.setText("");
    }
  }

  private void fixXMLData() {
    if (SceneManager.gameLoaded) {
      Player player = Player.getPlayer();
      if (player != null) {
        HashMap<String, String> data = scene.getData();
        if (data != null) {// getXML(String z, Map<String, String> m) 
          String s = RD.getXML("scene", data);
          txtXML.setText(s);
        } else {
          txtXML.setText("");
          txtButtonResponse.setText("SM_EditScene.enterScene xml: = null");
          Log.mes("SM_EditScene.enterScene xml: = null");
        }
      } else {
        txtButtonResponse.setText("SM_EditPlayer null player");
        Log.mes("SM_EditPlayer null player");
      }
    } else {
      txtButtonResponse.setText("game not loaded");
      Log.mes("SM_EditPlayer fixData game not loaded");
    }
  }

  private void loadData() {
    try {
      Player player = Player.getPlayer();
      loadPlayerData(player);

    } catch (Exception e) {
      Log.mes("SM_EditPlayer.changeScene " + e.toString());
    }
  }

  private void savePlayer() {
    String xml = txtXML.getText();
    Player player = null;
    if (xml.length() > 0) {
      player = new Player(xml);
    } else {
      txtButtonResponse.setText("No player to save, you must first load or set some data for player");
    }
  }
}
