package ge;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/**
 *
 * @author eddie
 */
public class SM_EditScene extends JPanel implements ActionListener {
  
  JTabbedPane tabs1;
  JTextArea desc;
  JTextField txtRow, txtCol, txtItem, txtNeed, txtNPC, txtXML;
  //JPanel pnlPos, pnlItem, pnlNeed, pnlNPC;
  JLabel lblName, lblRow, lblCol;
  JButton jbN, jbE, jbS, jbW, jbQ, jbLoad, jbSave;
  
  Scene scene;
  
  SM_EditScene(JTabbedPane tabs) {
    setLayout(new BorderLayout());
    fixNorthPanel();
    fixCenterPanel();
    fixSouthPanel();
    
    this.tabs1 = tabs;
    
  }
  
  private void fixNorthPanel() {
    
    JPanel jp = new JPanel();
    fixPositionDisplay(jp);
    
    lblName = new JLabel("Scene name goes here");
    Font f = lblName.getFont();
    Font f1 = new Font(f.getName(), Font.BOLD, 24);
    lblName.setFont(f1);
    jp.add(lblName);
    
    add(jp, BorderLayout.NORTH);
  }
  
  private void fixPositionDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblRow = new JLabel("Row:");
    txtRow = new JTextField(2);
    JLabel lblCol = new JLabel("Col:");
    txtCol = new JTextField(2);
    jp.add(lblRow);
    jp.add(txtRow);
    jp.add(lblCol);
    jp.add(txtCol);
    jp1.add(jp);
  }
  
  private void fixCenterPanel() {
    JPanel jp = new JPanel();
    desc = new JTextArea(6, 50);
       Font f = desc.getFont();
    Font f1 = new Font(f.getName(), Font.PLAIN, 16);   
    desc.setFont(f1);
    jp.add(desc);
    fixItemDisplay(jp);
    fixNeedDisplay(jp);
    fixNPCDisplay(jp);
    
    add(jp);
    
  }
  
  private void fixNeedDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblNeed = new JLabel("  Need:");
    txtNeed = new JTextField(50);
    jp.add(lblNeed);
    jp.add(txtNeed);
    jp1.add(jp);
  }
  
  private void fixItemDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblItem = new JLabel("  Item:");
    txtItem = new JTextField(50);
    jp.add(lblItem);
    jp.add(txtItem);
    jp1.add(jp);
  }
  
  private void fixNPCDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblNPC = new JLabel("  NPC:");
    txtNPC = new JTextField(50);
    jp.add(lblNPC);
    jp.add(txtNPC);
    jp1.add(jp);
  }
  
  private void fixSouthPanel() {
    JPanel jp = new JPanel();
    fixXMLDisplay(jp);
    fixNavButtons(jp);
    
    add(jp, BorderLayout.SOUTH);
  }

  private void fixXMLDisplay(JPanel jp1) {
    JPanel jp = new JPanel();
    JLabel lblXML = new JLabel("  XML:");
    txtXML = new JTextField(40);
    jp.add(lblXML);
    jp.add(txtXML);
    jp1.add(jp);
  }
  
 
  
    private void fixNavButtons(JPanel jp1) {
    JPanel jp = new JPanel();
    JButton jb = new JButton("some text");
    Font f = jb.getFont();
    Font f1 = new Font(f.getName(), Font.BOLD, 24);
    fixButton(jp, "Load", f1);
    fixButton(jp, "Save", f1);
    fixButton(jp, "N", f1);
    fixButton(jp, "E", f1);
    fixButton(jp, "S", f1);
    fixButton(jp, "W", f1);
    jp1.add(jp);
  }
  
  
private void fixButton(JPanel jp, String text, Font f1){  
    JButton jb = new JButton(text);
    jb.setFont(f1);
    jb.addActionListener(this);
    jp.add(jb);
}
  
  public void enterScene(String xml) {
    HashMap hm = RD.getDataMap(xml);
    int row = RD.getIntValue(hm, "row");
    int col = RD.getIntValue(hm, "col");
    this.scene = Scene.map[row][col];
    lblName.setText(scene.getName());
    fixDesc();
    fixNeed();
    fixItem();
    fixNPC();
    fixData();
    txtRow.setText(String.valueOf(scene.getRow()));
    txtCol.setText(String.valueOf(scene.getCol()));
    
    HashMap<String, String> data = scene.getData();
    if (data != null) {// getXML(String z, Map<String, String> m) 
      String s = RD.getXML("scene", data);
      txtXML.setText(s);
    }
    tabs1.setSelectedComponent(this);
  }
  
  private void fixDesc() {
    Desc desc1 = scene.getDesc();
    if (desc1 != null) {
      desc.setText(desc1.toString());
    } else {
      desc.setText("");
    }
  }
  
  private void fixNeed() {
    if (scene.getNeed() != null) {
      Item need = scene.getNeed();
      txtNeed.setText(need.toString());
      //Log.mes("SM_EditScene.enterScene need: " + need.toString());
    } else {
      txtNeed.setText("");
      //Log.mes("SM_EditScene.enterScene need: = null");
    }
  }

  private void fixItem() {
    if (scene.getItem() != null) {
      Item item = scene.getItem();
      txtItem.setText(item.toString());
      //Log.mes("SM_EditScene.enterScene need: " + item.toString());
    } else {
      txtItem.setText("");
      //Log.mes("SM_EditScene.enterScene item: = null");
    }
  }
  
  private void fixNPC() {
    if (scene.getNPC() != null) {
      NPC npc = scene.getNPC();
      txtNPC.setText(npc.toString());
      //Log.mes("SM_EditScene.enterScene npc: " + npc.toString());
    } else {
      txtNPC.setText("");
      //Log.mes("SM_EditScene.enterScene npc: = null");
    }
  }
  
  private void fixData() {
    HashMap<String, String> data = scene.getData();
    if (data != null) {// getXML(String z, Map<String, String> m) 
      String s = RD.getXML("scene", data);
      txtXML.setText(s);
    } else {
      txtXML.setText("");
     // Log.mes("SM_EditScene.enterScene xml: = null");
    }
  }
  
  public void actionPerformed(ActionEvent ae) {
    Object o = ae.getSource();
    if (o instanceof JButton) {
      JButton b = (JButton) o;
      String label = b.getText();
      int row = scene.getRow();
      int col = scene.getCol();
      if (label.equals("N")) {
        if (row > 0) {
          row--;
        }
      } else if (label.equals("E")) {
        if (col < (RD.cols - 1)) {
          col++;
        }
      } else if (label.equals("S")) {
        if (row < (RD.rows - 1))
          row++;
 
      } else if (label.equals("W")) {
        if (col > 0) {
          col--;
        }
      }
      try {
        Scene newScene = Scene.map[row][col];
        HashMap<String, String> map = newScene.getData();
        String xml = RD.getXML("scene", map);
        enterScene(xml);
      } catch (Exception ex) {
        Log.mes(ex);
      }
    }
  }
  
}
