package ge;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.util.*;
import java.io.*;

/**
 *
 * @author eddie
 */
public class SM_FileInput extends JPanel implements ActionListener, CB {

  JFileChooser chooser;
  JTabbedPane tabs;
  File inputFile;
  SM_Map smmap;

  public SM_FileInput(JTabbedPane tabs, SM_Map smmap) {
    this.tabs = tabs;
    this.smmap = smmap;
    JLabel heading = new JLabel("File Input");
    Font font1 = heading.getFont();
    Font font2 = new Font(font1.getName(), Font.BOLD, 24);
    heading.setFont(font2);
    add(heading);
    File file = new File(".");
    chooser = new JFileChooser(file);
    chooser.addActionListener(this);
    chooser.setPreferredSize(new Dimension(700, 390));
    chooser.setApproveButtonText("Load");
    add(chooser);

  }

  public int getFile() {
    FileNameExtensionFilter filter = new FileNameExtensionFilter(
            "JPG & GIF Images", "jpg", "gif");
    chooser.setFileFilter(filter);
    int returnVal = chooser.showOpenDialog(this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      System.out.println("You chose to open this file: "
              + chooser.getSelectedFile().getName());
    }
    return returnVal;
  }

  public void actionPerformed(ActionEvent ae) {
    JFileChooser jfc = null;
    JButton jb = null;
    Object o = ae.getSource();
    if (o instanceof JButton) {
      jb = (JButton) o;
      System.out.println("actionPerformed: " + jb.getText());
    } else if (o instanceof JFileChooser && (!SceneManager.gameLoaded)) {
      jfc = (JFileChooser) o;
      System.out.println("actionPerformed: JFileChooser " + chooser.getSelectedFile());
    } else {
      System.out.println("other actionevent");
    }
    if (ae.getActionCommand().equalsIgnoreCase("ApproveSelection")) {
      if (jfc != null) {
        inputFile = jfc.getSelectedFile();
        Log.mes("input file: " + inputFile.getName());
        IO io = new IO(inputFile);
        RD.readData1(io);
        SceneManager.gameLoaded = true;
        smmap.populate();
      } else {
        Log.mes("bad  jfc");
      }
    } else if (ae.getActionCommand().equalsIgnoreCase("CancelSelection")) {
      Log.mes(" input file selection cancelled");
    } else {
      Log.mes("SM_FileInput got bad action command:" + ae.getActionCommand());
    }

  }

  public void callBack(String s) {

  }
}
