package ge;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.io.*;

/**
 *
 * @author eddie
 */
public class SM_FileOutput extends JPanel implements ActionListener {

    JFileChooser chooser;
    JTabbedPane tabs;
    File outputFile;

    public SM_FileOutput(JTabbedPane tabs) {
        this.tabs = tabs;
        JLabel heading = new JLabel("File Output");
        Font font1 = heading.getFont();
        Font font2 = new Font(font1.getName(), Font.BOLD, 24);
        heading.setFont(font2);
        add(heading);
        File file = new File(".");
        chooser = new JFileChooser(file);
        chooser.addActionListener(this);
        chooser.setPreferredSize(new Dimension(700, 390));
        chooser.setApproveButtonText("Save");
        FileNameExtensionFilter filter = new FileNameExtensionFilter(
                "Text & Game files", "txt", "game");
        chooser.setFileFilter(filter);
        add(chooser);

    }

    public int getFile() {
        FileNameExtensionFilter filter = new FileNameExtensionFilter(
                "JPG & GIF Images", "jpg", "gif");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            System.out.println("You chose to open this file: "
                    + chooser.getSelectedFile().getName());
        }
        return returnVal;
    }

    public void actionPerformed(ActionEvent ae) {
        JFileChooser jfc = null;
        JButton jb = null;
        Object o = ae.getSource();
        if (o instanceof JButton) {
            jb = (JButton) o;
            System.out.println("actionPerformed: " + jb.getText());
        } else if (o instanceof JFileChooser) {
            jfc = (JFileChooser) o;
        } else {
            System.out.println("other actionevent");
        }
        if (ae.getActionCommand().equalsIgnoreCase("ApproveSelection")) {
            if (jfc != null) {
                outputFile = jfc.getSelectedFile();
                Log.mes("input file: " + outputFile.getName());
            } else {
                Log.mes("bad  jfc");
            }
        } else if (ae.getActionCommand().equalsIgnoreCase("CancelSelection")) {
            Log.mes(" input file selection cancelled");
        } else {
            Log.mes("SM_FileInput got bad action command:" + ae.getActionCommand());
        }

    }
}
