/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package ge;

import static ge.Scene.map;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/**
 *
 * @author eddie
 */
public class SM_Map extends JPanel implements ActionListener {
  static SM_Map smmap;
  SM_EditScene editScene = null;
  JTabbedPane tabs = null;
  JButton jbDisplayPanel;  
  JPanel displayPanel;
  
  SM_Map(SM_EditScene editScene, JTabbedPane tabs) {
    SM_Map.smmap = this;
    this.editScene = editScene;
    this.tabs = tabs;
    setLayout(new BorderLayout());
    addTopPanel();
    displayPanel = getDisplayPanel();
    add(displayPanel);
    
  }
  
  private void addTopPanel() {
    JPanel bp = new JPanel();
    // JButton jbDisplayPanel = new JButton(showSelectedScene);
    JLabel lblGame = new JLabel(RD.game);
    Font f = lblGame.getFont();
    Font f1 = new Font(f.getName(), Font.BOLD, 28);
    lblGame.setFont(f1);
    bp.add(lblGame);
    //jb.addActionListener(this);

    add(bp, BorderLayout.NORTH);
  }
  
  private JPanel getDisplayPanel() {
    JPanel bp = new JPanel();
    
    return bp;
  }
  
  public void populate() {
    try {
      displayPanel.setLayout(new GridLayout(RD.rows, RD.cols));
      for (int row = 0; row < RD.rows; row++) {
        for (int col = 0; col < RD.cols; col++) {
          Scene scene = Scene.map[row][col];
          if (scene != null) {
            JPanel jp1 = new JPanel();
            String name = scene.getName();
            String html = "<html><bold>" + name + "</bold>";
            NPC npc = scene.getNPC();
            if (npc != null) {
              html += "<br>npc: " + npc.getKey();
            }
            Item item = scene.getItem();
            if (item != null) {
              html += "<br>has " + item.getKey();
            }
            Item need = scene.getNeed();
            if (need != null) {
              html += "<br>needs " + need.getKey();
            }
            jbDisplayPanel = new JButton(html);
            String xml = RD.getXML("Scene", scene.getData());
            jbDisplayPanel.setActionCommand(xml);
            displayPanel.add(jbDisplayPanel);
            jbDisplayPanel.addActionListener(this);
          }
        }
      }
      //tabs.setSelectedComponent(this);          
    } catch (Exception ex) {
      Log.mes(ex);
    }
  }
  
  @Override
  public void actionPerformed(ActionEvent ae) {
    Object o = ae.getSource();
    if (o instanceof JButton) {
      JButton jb = (JButton) o;
      //  String s = jbDisplayPanel.getText();
      //  System.out.println("Button pressed: " + s);
      String xml = jb.getActionCommand();
      editScene.enterScene(xml);
    }
  }
  
}
