package ge;

import java.util.*;

/**
 * A scene in the game
 *
 * @author e55023
 */
public class Scene implements CB {

    private final HashMap<String, String> data;
    private HashMap <String, String> playerData;
    private Player player;
    private int status;
    /**
     * description of scene
     */
    Desc desc;
    Desc ext, exte, exts, extw, extn;// external view, general or from particular direction
    // eg extn would be as seen from the north looking south
    Desc exit;// exiting desc, would need a delay 

    public Scene(String xml) {
        data = RD.getDataMap(xml);
    }

    
    
    public int enterScene(Player player, HashMap<String, String> playerData) {
        this.playerData = playerData;
        this.player = player;

        try {
            boolean ok = true; // maybe set false if player lacks item
            DosSim.clear();
            DosSim.print("row: " + getRow() + ", col: " + getCol() + "\n");
            //System.out.print("\033[H\033[2J");
            
            //Log.map("Entered scene " + player.getRow() + ", "+ player.getCol(), data);
            if (null != desc) {
                desc.print(this,"<next=es1>");
            }
        } catch (Exception ex) {
            Log.mes(ex);
        }
        return status;
    }

  private int es1(){
          try{  
            DosSim.print("\n");
            if (getNPC() != null) {
                DosSim.print (getNPC().toString() + "\n");
            }
            if (getItem() != null) {
                DosSim.print(getItem().toString() + "\n");
            }
              if (null != getNeed()) {
                DosSim.print(" Needs: " + getNeed().toString() + "\n");
            }
            if (getDie() != 0) {
                status = getDie();
            } else if (getWin() > 0) {
                status = getWin();
            }
            player.callBack("<move=>");
        } catch (Exception ex) {
            Log.mes(ex);
        }
        return status;
    }
    
  public void callBack(String xml){
    Log.mes("Scene.callBack xml: " + xml);
    String next = RD.getRHS(xml);
    switch (next){
      case "es1": es1(); break;
      default: Log.mes("Scene.callBack default");

    }
    
  }
    
    public  HashMap<String, String> getData(){
        if (this == null) return null;
        return data;
    }

    public void setExit(Desc exit) {
        if (this == null) return;
       this.exit = exit;
    }

    public void setDesc(Desc desc) {
        if (this == null) return;
        this.desc = desc;
    }

    public String getName() {
        if (this == null) return null;
        return data.get("name");
    }

    public Desc getDesc() {
        if (this == null) return null;
        return desc;
    }

    public NPC getNPC() {
        if (this == null) return null;
        //Log.mapNPC("scene.getNPC", NPC.npcs);
        NPC npc = null;
        String strNPC = data.get("npc");
        //Log.mes("sene.getNPC strNPC: " + strNPC );
        if(strNPC != null && strNPC.length() > 0)
           npc = (NPC) NPC.npcs.get(strNPC);
        return npc;
    }

    public Item getItem() {
        if (this == null) return null;
        Item item = null;
        String strItem = data.get("item");
        //Log.mes("Scene.getItem strItem: " + strItem);
        if(strItem != null && strItem.length() > 0)
           item = (Item) Item.items.get(strItem);
       // if(item == null)
       //   Log.mes("Scene.getItem = null");
       // else
       //   Log.mes("Scene.getItem item: " + item.toString());
        return item;
    }
    
    public void removeItem(Item item){
        if (this == null) return;
      String key = item.getKey();
      Log.mes("Scene.removeItem key: " + key);
      String strItem = data.remove("item");
      if(strItem == null){
        Log.mes("Scene.removeItem returns null for key: " + key);
       // boolean containsKey = data.contains(key);
      } else
        player.addItem(key);
    }

    public Item getNeed() {
        if (this == null) return null;
        Item need = null;
        String strNeed = data.get("need");
        if(strNeed != null && strNeed.length() > 0)
            need = (Item) Item.items.get(strNeed);
        return need;
    }

    public int getRow() {
        if (this == null) return -1;
        return RD.getIntValue(data, "row");
    }

    public int getCol() {
        if (this == null) return -1;
        return RD.getIntValue(data, "col");
    }

    public int getDie() {
        if (this == null) return -1;
        String strDie = data.get("die");
        int die = 0;
        try {
            if (strDie != null && strDie.length() > 0) {
                die = Integer.parseInt(strDie);
            }
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return die;
    }

    public int getWin() {
        if (this == null) return -1;
        String strWin = data.get("win");
        int win = 0;
        try {
            if (strWin != null && strWin.length() > 0) {
                win = Integer.parseInt(strWin);
            }
        } catch (Exception ex) {
            System.out.println(ex.toString());
        }
        return win;
    }

    private static void fillMissingScenes(String name, Desc desc, IO io) {
        try {
            Log.mes("fillMissingScenes about to set up " );
            Scene scene = null;
            for (int row = 0; row < RD.rows; row++) {
                for (int col = 0; col < RD.cols; col++) {
                    if (map[row][col] == null) {
                        StringBuilder xml = new StringBuilder();
                        xml.append( "<scene name=default row=");
                        xml.append(row);
                        xml.append(" col=");
                        xml.append(col);
                        xml.append(">");
                        //Log.mes("fillMissingScenes xml: " + xml);
                        scene = new Scene(xml.toString());
                        map[row][col] = scene;// put this default scene instance on the map
                    }
                }
            }
        } catch (Exception e) {
            Log.mes(e);
        }
    }

    public static void readScene(IO fr, String s) {
        try{
        Scene scene = new Scene(s);
        //Log.mes("readscene name=" + scene.getName());
        boolean done = false;
        while (!done) {
            s = fr.nextLine();
            if (s.length() > 0) {
                if (RD.debug) {
                    Log.mes("scene line" + fr.getLineNumber() + ": " + s);// diagnostic
                }
                if (s.startsWith("<desc")) {
                    scene.desc = Desc.readDesc(fr);
                } else if (s.startsWith("<exit")) {
                    scene.setExit(Desc.readDesc(fr));
                } else if (scene.getName().equals("default")) {// should be last in text file
                    scene.fillMissingScenes(scene.getName(), scene.desc, fr);
                    done = true;
                } else if (s.startsWith("</scene")) {
                    done = true;
                     map[scene.getRow()][scene.getCol()] = scene;
                } else {
                    RD.report("Bad Scene tag", fr, s);
                }
            }
        }
        }catch(Exception e) {
            Log.mes(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getName());
        sb.append(", row: ");
        sb.append(getRow());
        sb.append(", col: ");
        sb.append(getCol());
        NPC npc = getNPC();// get the npc key
        if (npc != null) {
            sb.append(", npc: ");
            sb.append(npc.getKey());
        }
        Item item = getItem();
        if (item != null) {
            sb.append(", item: ");
            sb.append(item.getKey());
        }
        int win = getWin();
        if (win > 0) {
            sb.append(", win! ");
        }
        sb.append("\n\n");
        sb.append(desc.toString());
        return sb.toString();
    }
    /**
     * map
     */
    public static Scene[][] map;

}// end Scene class

