package ge;

import static ge.Scene.map;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
/**
 *
 * @author eddie
 */
public class SceneManager extends JFrame implements ChangeListener {
     public static  boolean gameLoaded = false;
    String showSelectedScene = "Show Selected Scene";
    JTabbedPane tabs;
    SM_EditScene editScene; 
    SM_EditPlayer editPlayer;
    SM_Map smmap; 
    SM_FileInput fileInput;
    SM_FileOutput fileOutput;
    DosSim ds;
    
    
    public SceneManager() {
        super("Scene Manager v0.2");
        tabs = new JTabbedPane();
        
        editPlayer = new SM_EditPlayer(tabs);
        editScene = new SM_EditScene(tabs);
        smmap = new SM_Map(editScene, tabs);
        fileInput = new SM_FileInput(tabs, smmap);
        fileOutput = new SM_FileOutput(tabs);
        ds = new DosSim(this, smmap);
        
        tabs.addTab("DOS Sim", ds);
        tabs.addTab("Map", smmap);
        tabs.addTab("Edit Player", editPlayer);
        tabs.addTab("Edit Scene", editScene);
        tabs.addTab("File Input", fileInput);
        tabs.addTab("File Output", fileOutput);
        
        add(tabs);
        tabs.addChangeListener(this);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setBounds(10, 10, 1000, 600);
        setVisible(true);
        ds.setFocus();
    }
    
    public SM_Map getSM_Map() {
      return smmap;
    }

    @Override
     public void stateChanged(ChangeEvent ce){
        Component selectedTab =  tabs.getSelectedComponent();
        if(selectedTab == ds){
          ds.setFocus();
        }
     }


   // public void addScenesPanel(){
      
   // }


     
    public static void main(String[] args) {
        Log.mes("SceneManager main: Working Directory = " + System.getProperty("user.dir"));
       // RD.readData();
        new SceneManager();
    }


}
