/*
 * Decompiled with CFR 0.152.
 */
package hexdump;

import hexdump.HexDump;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class FileIn {
    String fileName;
    HexDump hd;
    private static RandomAccessFile raf;
    private static File currentFile;
    private static File currentFolder;

    public FileIn(HexDump hd, String fileName) {
        this.fileName = fileName;
        this.hd = hd;
        try {
            currentFile = new File(fileName);
            String absFile = currentFile.getAbsoluteFile().toString();
            int pos = absFile.lastIndexOf(File.separator);
            String parent = absFile.substring(0, pos);
            currentFolder = new File(parent);
            System.out.println("currentFolder: " + String.valueOf(currentFolder));
            raf = new RandomAccessFile(currentFile, "r");
            long length = raf.length();
            System.out.print("File " + fileName + " has " + length);
            System.out.printf(" (%08x)", length);
            System.out.println(" bytes.");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static File getCurrentFile() {
        return currentFile;
    }

    public static void setCurrentFile(File currentFile1) {
        if (currentFile1 == null) {
            raf = null;
            currentFile = null;
        } else {
            currentFile = currentFile1;
            try {
                raf = new RandomAccessFile(currentFile1, "r");
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public static File getCurrentFolder() {
        return currentFolder;
    }

    public static void setCurrentFolder(File currentFolder) {
        FileIn.currentFolder = currentFolder;
    }

    public boolean isOk() {
        boolean ok = false;
        try {
            if (raf.length() > 0L) {
                ok = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public byte[] getByteRow(long dumpAddress, int format) {
        byte[] bytes;
        block8: {
            bytes = null;
            int qty = 16;
            if (format == 2) {
                qty = 8;
            }
            if (raf != null) {
                try {
                    if (dumpAddress >= raf.length()) break block8;
                    bytes = new byte[qty];
                    try {
                        raf.seek(dumpAddress);
                        int byteQty = raf.read(bytes);
                        if (byteQty != qty) {
                            byte[] line1 = new byte[byteQty];
                            for (int i = 0; i < byteQty; ++i) {
                                line1[i] = bytes[i];
                            }
                            bytes = line1;
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
        }
        return bytes;
    }

    public static ArrayList<File> loadFoldersAndFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (File fileEntry : currentFolder.listFiles()) {
            if (!fileEntry.isDirectory()) continue;
            list.add(fileEntry);
        }
        for (File fileEntry : currentFolder.listFiles()) {
            if (!fileEntry.isFile()) continue;
            list.add(fileEntry);
        }
        return list;
    }

    public static void loadFiles(File folder, List<File> fileList) {
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                FileIn.loadFiles(fileEntry, fileList);
                continue;
            }
            fileList.add(fileEntry);
        }
    }

    public static void loadFilesForFolder(File folder, List<String> fileList) {
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) {
                FileIn.loadFilesForFolder(fileEntry, fileList);
                continue;
            }
            fileList.add(fileEntry.getParent() + File.separator + fileEntry.getName());
        }
    }

    public static void useLoadFilesForFolder() {
        ArrayList<File> fileList = new ArrayList<File>();
        File folder = new File("./../");
        FileIn.loadFiles(folder, fileList);
        int count = 0;
        for (File fileName : fileList) {
            System.out.printf(" %4d ", count++);
            System.out.println(fileName.getParent() + File.separator + fileName.getName());
        }
    }

    public static File getParent(File file) {
        File parent = file;
        String absFile = file.getAbsolutePath();
        int pos = absFile.lastIndexOf(File.separator);
        if (pos > 1) {
            String strParent = absFile.substring(0, pos);
            parent = new File(strParent);
        }
        return parent;
    }

    public static String getFileString(File file) {
        String answer = null;
        String absFile = file.getAbsolutePath();
        int pos = absFile.lastIndexOf(File.separator);
        if (pos > -1) {
            answer = absFile.substring(pos + 1);
        }
        return answer;
    }

    public static void x(File file) {
        System.out.println("Executable: " + file.canExecute());
        System.out.println("Readable: " + file.canRead());
        System.out.println("Writable: " + file.canWrite());
    }
}

