/*
 * Decompiled with CFR 0.152.
 */
package hexdump;

import hexdump.FileIn;
import java.io.File;
import java.util.ArrayList;
import java.util.Scanner;

public class HexDump {
    private static String usage = "Usage: \n HexDump inputFile\n";
    private static String prompt = "\nHexDump Menu:\n 0-9999 to select file or folder after d:\n a: enter next hexdump hexidecimal address\n d: show directories and files in current folder\n h: hex dump next 16 bytes - optionally decimal line count follows\n o: octal dump next 16 bytes - optionally decimal line count follows\n s: enter silent mode (no prompts)\n ?: exit silent mode\n u: go up to parent folder\n x: exit hexdump program\n  press number or letter for required function: ";
    private FileIn fi;
    private String fileName;
    private int dumpAddress;
    private ArrayList<File> dirList;
    boolean silent = false;
    private int format = 0;

    private HexDump(String fileName) {
        this.fileName = fileName;
        this.fi = new FileIn(this, fileName);
        if (this.fi.isOk()) {
            this.run();
        }
    }

    private void run() {
        Scanner kb = new Scanner(System.in);
        boolean done = false;
        boolean isNumeric = false;
        while (!done) {
            String s;
            if (!this.silent) {
                System.out.println("Current File:     " + String.valueOf(FileIn.getCurrentFile()));
                System.out.print(prompt);
            }
            if ((s = kb.nextLine()).length() <= 0) continue;
            try {
                int dirChoice = Integer.parseInt(s);
                this.select(dirChoice);
                isNumeric = true;
            }
            catch (Exception e) {
                isNumeric = false;
            }
            if (isNumeric) continue;
            done = this.doChoice(s);
        }
    }

    private boolean doChoice(String s) {
        boolean done = false;
        switch (s.charAt(0)) {
            case 'a': {
                this.addressChange(s);
                break;
            }
            case 'b': {
                this.doDump(s, 2);
                break;
            }
            case 'h': {
                this.doDump(s, 0);
                break;
            }
            case 'o': {
                this.doDump(s, 1);
                break;
            }
            case 'd': {
                this.showDir();
                break;
            }
            case 's': {
                this.silent = true;
                break;
            }
            case 'x': {
                done = true;
                break;
            }
            case 'u': {
                this.goUp();
                break;
            }
            case '?': {
                this.silent = false;
                break;
            }
            default: {
                System.out.println("Could not understand " + s);
            }
        }
        return done;
    }

    private void goUp() {
        HexDump hexDump = this;
        FileIn.setCurrentFolder(FileIn.getParent(hexDump.fi.getCurrentFolder()));
        FileIn.setCurrentFile(null);
        this.showDir();
    }

    private void select(int fileItem) {
        try {
            File file = this.dirList.get(fileItem);
            System.out.println("file: " + String.valueOf(file));
            if (file.isDirectory()) {
                FileIn.setCurrentFolder(file);
                FileIn.setCurrentFile(null);
                this.showDir();
            } else {
                this.dumpAddress = 0;
                FileIn.setCurrentFile(file);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    private void showDir() {
        this.dirList = FileIn.loadFoldersAndFiles();
        System.out.println("\nDir llisting of " + FileIn.getCurrentFolder().toString() + "\n");
        int count = 0;
        for (File file : this.dirList) {
            System.out.printf(" %4d ", count++);
            if (file.isDirectory()) {
                System.out.print("d ");
            } else if (file.isFile()) {
                System.out.print("f ");
                System.out.printf(" %7d ", file.length());
                System.out.print(" ");
            } else {
                System.out.println("Neither d nor f : ");
            }
            System.out.println(FileIn.getFileString(file));
        }
        System.out.println();
    }

    private void addressChange(String s) {
        String s1 = s.substring(1);
        this.dumpAddress = this.hex2Int(s1);
    }

    private void doDump(String s, int format) {
        if (s.length() == 1) {
            this.dumpOneLine(format);
        } else {
            try {
                s = s.substring(1);
                s = s.strip();
                System.out.println("doDump line repeat: <" + s + ">");
                int count = Integer.parseInt(s);
                while (count-- > 0) {
                    this.dumpOneLine(format);
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    private void dumpOneLine(int format) {
        byte[] bytes = this.fi.getByteRow(this.dumpAddress, format);
        if (bytes != null) {
            System.out.printf("%06x:", this.dumpAddress);
            this.dumpAddress += bytes.length;
            for (int i = 0; i < bytes.length; ++i) {
                try {
                    if (i % 4 == 0) {
                        System.out.print(" ");
                    }
                    switch (format) {
                        case 0: {
                            System.out.printf("%02x ", bytes[i]);
                            break;
                        }
                        case 1: {
                            System.out.printf("%03o ", bytes[i]);
                            break;
                        }
                        case 2: {
                            System.out.print(this.getBinary(bytes[i]));
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
            System.out.print(" - ");
            for (byte b : bytes) {
                if (b > 31 && b < 127) {
                    System.out.print((char)b);
                    continue;
                }
                System.out.print(".");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            new HexDump(args[0]);
        } else {
            System.out.println(usage);
        }
    }

    private String getBinary(byte b) {
        StringBuilder answer = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (b < 0) {
                answer.append("1");
            } else {
                answer.append("0");
            }
            b = (byte)(b * 2);
        }
        return answer.toString() + " ";
    }

    private int hex2Int(String s) {
        String ref = "0123456789abcdef";
        int answer = 0;
        if ((s = s.strip().toLowerCase()).length() > 0) {
            for (int i = 0; i < s.length(); ++i) {
                int ival = ref.indexOf(s.charAt(i));
                if (ival <= -1) continue;
                answer = answer * 16 + ival;
            }
        }
        return answer;
    }
}

