package hexdump;

import java.io.*;
import java.util.*;

/**
 *
 * @author eddie
 */
public class FileIn {

  String fileName;
  HexDump hd;
  private static RandomAccessFile raf;
  private static File currentFile;
  private static File currentFolder;

  public FileIn(HexDump hd, String fileName) {
    this.fileName = fileName;
    this.hd = hd;
    try {
      currentFile = new File(fileName);
      String absFile = currentFile.getAbsoluteFile().toString();
      //System.out.println("getAbsoluteFile(): " + file.getAbsoluteFile());
      //System.out.println("getAbsolutePath(): " + file.getAbsolutePath());
      //System.out.println("getCanonicalFile(): " + file.getCanonicalFile());
      //System.out.println("getCanonicalPath(): " + file.getCanonicalPath());
      int pos = absFile.lastIndexOf(File.separator);
      //System.out.println("lastIndexOf(File.separator); " + pos);
      String parent = absFile.substring (0, pos);
      //System.out.println("parent: " + parent);
      currentFolder = new File(parent);
      System.out.println("currentFolder: " + currentFolder);

      raf = new RandomAccessFile(currentFile, "r");
      long length = raf.length();
      System.out.print("File " + fileName + " has " + length);
      System.out.printf(" (%08x)", length);
      System.out.println( " bytes.");

    } catch (Exception e) {
      System.out.println(e.toString());
    }
  }

  public static File getCurrentFile(){
    return currentFile;
  }
 
  public static void setCurrentFile(File currentFile1) {
    if (currentFile1 == null) {
      raf = null;
      currentFile = null;
    } else {
      currentFile = currentFile1;
      try {
        raf = new RandomAccessFile(currentFile1, "r");
      } catch (Exception e) {
        System.out.println(e.toString());
      }
    }
  }


  public static File getCurrentFolder() {
    return currentFolder;
  }

  public static void setCurrentFolder(File currentFolder) {
    FileIn.currentFolder = currentFolder;
  }
  

  public boolean isOk() {
    boolean ok = false;
    try {
      if (raf.length() > 0) {
        ok = true;
      }
    } catch (Exception e) {
    }
    return ok;
  }

  public byte[] getByteRow(long dumpAddress, int format) {
    byte[] bytes = null;
    int qty = 16;
    if(format == 2)
      qty = 8; // want binary format
    if (raf != null) {
      try {
        if (dumpAddress < raf.length()) {
          bytes = new byte[qty];
          try {
            raf.seek(dumpAddress);
            int byteQty = raf.read(bytes);
            if (byteQty != qty) {
              byte[] line1 = new byte[byteQty];
              for (int i = 0; i < byteQty; i++) {
                line1[i] = bytes[i];
              }
              bytes = line1;
            }
          } catch (Exception e) {
            System.out.println(e.toString());
          }
        }
      } catch (Exception e) {
        System.out.println(e.toString());
      }
    }
    return bytes;
  }

  public static ArrayList<File> loadFoldersAndFiles() {
    ArrayList<File> list = new ArrayList<>();
    // first collect any folders.
    for (File fileEntry : currentFolder.listFiles()) {
      if (fileEntry.isDirectory()) {
        list.add(fileEntry);
      } 
    }
    // second collect any files.
    for (File fileEntry : currentFolder.listFiles()) {
      if (fileEntry.isFile()) {
        list.add(fileEntry);
      } 
    }
    return list;
  }

  public static void loadFiles(final File folder, List<File> fileList) {
    for (final File fileEntry : folder.listFiles()) {
      if (fileEntry.isDirectory()) {
        loadFiles(fileEntry, fileList);
      } else {
       // fileList.add(fileEntry.getParent() + File.separator + fileEntry);
        fileList.add(fileEntry);
      }
    }
  }


  /**
   * https://stackoverflow.com/questions/1844688/how-can-i-read-all-files-in-a-folder-from-java/23814217#23814217
   */
  public static void loadFilesForFolder(final File folder, List<String> fileList) {
    for (final File fileEntry : folder.listFiles()) {
      if (fileEntry.isDirectory()) {
        loadFilesForFolder(fileEntry, fileList);
      } else {
        fileList.add(fileEntry.getParent() + File.separator + fileEntry.getName());
      }
    }
  }

  public static void useLoadFilesForFolder() {
//    List<String> fileList = new ArrayList<>();
    List<File> fileList = new ArrayList<>();
    final File folder = new File("./../");
   // final File folder = new File(".");
//    loadFilesForFolder(folder, fileList);
    loadFiles(folder, fileList);

// Dump file list values
//    for (String fileName : fileList) {
    int count = 0;
    for (File fileName : fileList) {
      System.out.printf(" %4d ", (count++));
      //System.out.print((count++) +": ");
//      System.out.println(fileName.getAbsoluteFile());
        System.out.println(fileName.getParent() + File.separator + fileName.getName() );
    }
  }
 
  public static File getParent(File file) {
    File parent = file;
    String absFile = file.getAbsolutePath();
    int pos = absFile.lastIndexOf(File.separator);
    if (pos > 1) {
      String strParent = absFile.substring(0, pos);
      parent = new File(strParent);
    }
    return parent;
  }

  public static String getFileString(File file) {
    String answer = null;
    String absFile = file.getAbsolutePath();
    int pos = absFile.lastIndexOf(File.separator);
    if (pos > -1) {
      answer = absFile.substring(pos + 1);
    }
    return answer;
  }

  
  public static void x(File file) {
    // Printing the permissions associated
    // with the file
    System.out.println("Executable: "
            + file.canExecute());
    System.out.println("Readable: "
            + file.canRead());
    System.out.println("Writable: "
            + file.canWrite());
  }
}
